"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapScopedClusterClient = wrapScopedClusterClient;
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _asInternalUser = /*#__PURE__*/new WeakMap();
var _asCurrentUser = /*#__PURE__*/new WeakMap();
var _asSecondaryAuthUser = /*#__PURE__*/new WeakMap();
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WrappedScopedClusterClient {
  constructor(opts) {
    _classPrivateFieldInitSpec(this, _asInternalUser, void 0);
    _classPrivateFieldInitSpec(this, _asCurrentUser, void 0);
    _classPrivateFieldInitSpec(this, _asSecondaryAuthUser, void 0);
    this.opts = opts;
  }
  get asInternalUser() {
    if (_classPrivateFieldGet(_asInternalUser, this) === undefined) {
      const {
        scopedClusterClient,
        ...rest
      } = this.opts;
      _classPrivateFieldSet(_asInternalUser, this, wrapEsClient({
        ...rest,
        esClient: scopedClusterClient.asInternalUser
      }));
    }
    return _classPrivateFieldGet(_asInternalUser, this);
  }
  get asCurrentUser() {
    if (_classPrivateFieldGet(_asCurrentUser, this) === undefined) {
      const {
        scopedClusterClient,
        ...rest
      } = this.opts;
      _classPrivateFieldSet(_asCurrentUser, this, wrapEsClient({
        ...rest,
        esClient: scopedClusterClient.asCurrentUser
      }));
    }
    return _classPrivateFieldGet(_asCurrentUser, this);
  }
  get asSecondaryAuthUser() {
    if (_classPrivateFieldGet(_asSecondaryAuthUser, this) === undefined) {
      const {
        scopedClusterClient,
        ...rest
      } = this.opts;
      _classPrivateFieldSet(_asSecondaryAuthUser, this, wrapEsClient({
        ...rest,
        esClient: scopedClusterClient.asSecondaryAuthUser
      }));
    }
    return _classPrivateFieldGet(_asSecondaryAuthUser, this);
  }
}
function wrapScopedClusterClient(opts) {
  return new WrappedScopedClusterClient(opts);
}
function wrapEsClient(opts) {
  const {
    esClient,
    ...rest
  } = opts;
  const wrappedClient = esClient.child({});

  // Mutating the functions we want to wrap
  wrappedClient.search = getWrappedSearchFn({
    esClient: wrappedClient,
    ...rest
  });
  return wrappedClient;
}
function getWrappedSearchFn(opts) {
  const originalSearch = opts.esClient.search;

  // A bunch of overloads to make TypeScript happy

  async function search(params, options) {
    try {
      const searchOptions = options !== null && options !== void 0 ? options : {};
      return await originalSearch.call(opts.esClient, params, {
        ...searchOptions,
        signal: opts.abortController.signal
      });
    } catch (e) {
      if (opts.abortController.signal.aborted) {
        throw new Error('Search has been aborted due to cancelled execution');
      }
      throw e;
    }
  }
  return search;
}