"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertInstanceFactoryStub = void 0;
var _uuid = require("uuid");
var _alert = require("@kbn/alerting-plugin/server/alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertInstanceFactoryStub = id => ({
  getState() {
    return {};
  },
  replaceState(state) {
    return new _alert.Alert('', {
      state: {},
      meta: {
        lastScheduledActions: {
          group: 'default',
          date: new Date().toISOString()
        }
      }
    });
  },
  scheduleActions(actionGroup, alertcontext) {
    return new _alert.Alert('', {
      state: {},
      meta: {
        lastScheduledActions: {
          group: 'default',
          date: new Date().toISOString()
        }
      }
    });
  },
  setContext(alertContext) {
    return new _alert.Alert('', {
      state: {},
      meta: {
        lastScheduledActions: {
          group: 'default',
          date: new Date().toISOString()
        }
      }
    });
  },
  getContext() {
    return {};
  },
  getStart() {
    return null;
  },
  hasContext() {
    return false;
  },
  getUuid() {
    return (0, _uuid.v4)();
  }
});
exports.alertInstanceFactoryStub = alertInstanceFactoryStub;