"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeRuleStatsAggregation = exports.getRuleStatsAggregation = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleStatsAggregation = () => {
  const rulesByEnabled = {
    terms: {
      field: 'alert.attributes.enabled'
    }
  };
  return {
    rulesByEnabled,
    rulesByOrigin: {
      terms: {
        field: 'alert.attributes.params.immutable'
      },
      aggs: {
        rulesByEnabled
      }
    },
    rulesByType: {
      terms: {
        field: 'alert.attributes.alertTypeId'
      },
      aggs: {
        rulesByEnabled
      }
    },
    rulesByOutcome: {
      terms: {
        field: 'alert.attributes.lastRun.outcome'
      },
      aggs: {
        rulesByEnabled
      }
    }
  };
};
exports.getRuleStatsAggregation = getRuleStatsAggregation;
const normalizeRuleStatsAggregation = aggregations => {
  const rulesByEnabled = aggregations.rulesByEnabled || {};
  const rulesByOrigin = aggregations.rulesByOrigin || {};
  const rulesByType = aggregations.rulesByType || {};
  const rulesByOutcome = aggregations.rulesByOutcome || {};
  return {
    number_of_rules: {
      all: normalizeByEnabled(rulesByEnabled),
      by_origin: normalizeByOrigin(rulesByOrigin),
      by_type: normalizeByAnyKeyword(rulesByType),
      by_outcome: normalizeByAnyKeyword(rulesByOutcome)
    }
  };
};
exports.normalizeRuleStatsAggregation = normalizeRuleStatsAggregation;
const normalizeByEnabled = rulesByEnabled => {
  const getEnabled = value => {
    var _rulesByEnabled$bucke;
    const bucket = rulesByEnabled === null || rulesByEnabled === void 0 ? void 0 : (_rulesByEnabled$bucke = rulesByEnabled.buckets) === null || _rulesByEnabled$bucke === void 0 ? void 0 : _rulesByEnabled$bucke.find(b => b.key_as_string === value);
    return Number((bucket === null || bucket === void 0 ? void 0 : bucket.doc_count) || 0);
  };
  const enabled = getEnabled('true');
  const disabled = getEnabled('false');
  return {
    total: enabled + disabled,
    enabled,
    disabled
  };
};
const normalizeByOrigin = rulesByOrigin => {
  const getOrigin = value => {
    var _rulesByOrigin$bucket;
    const bucket = rulesByOrigin === null || rulesByOrigin === void 0 ? void 0 : (_rulesByOrigin$bucket = rulesByOrigin.buckets) === null || _rulesByOrigin$bucket === void 0 ? void 0 : _rulesByOrigin$bucket.find(b => b.key === value);
    return normalizeByEnabled(bucket === null || bucket === void 0 ? void 0 : bucket.rulesByEnabled);
  };
  const prebuilt = getOrigin('true');
  const custom = getOrigin('false');
  return {
    prebuilt,
    custom
  };
};
const normalizeByAnyKeyword = rulesByAnyKeyword => {
  var _rulesByAnyKeyword$bu;
  const kvPairs = rulesByAnyKeyword === null || rulesByAnyKeyword === void 0 ? void 0 : (_rulesByAnyKeyword$bu = rulesByAnyKeyword.buckets) === null || _rulesByAnyKeyword$bu === void 0 ? void 0 : _rulesByAnyKeyword$bu.map(b => {
    const bucketKey = b.key;
    const rulesByEnabled = (b === null || b === void 0 ? void 0 : b.rulesByEnabled) || {};
    return {
      [bucketKey]: normalizeByEnabled(rulesByEnabled)
    };
  });
  return Object.assign({}, ...kvPairs);
};