"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateRule = void 0;
var _apply_rule_update = require("../mergers/apply_rule_update");
var _utils = require("../../../utils/utils");
var _validate = require("../../../utils/validate");
var _convert_rule_response_to_alerting_rule = require("../converters/convert_rule_response_to_alerting_rule");
var _utils2 = require("../utils");
var _get_rule_by_id_or_rule_id = require("./get_rule_by_id_or_rule_id");
var _convert_alerting_rule_to_rule_response = require("../converters/convert_alerting_rule_to_rule_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateRule = async ({
  actionsClient,
  rulesClient,
  prebuiltRuleAssetClient,
  ruleUpdate,
  mlAuthz
}) => {
  const {
    rule_id: ruleId,
    id
  } = ruleUpdate;
  await (0, _utils2.validateMlAuth)(mlAuthz, ruleUpdate.type);
  const existingRule = await (0, _get_rule_by_id_or_rule_id.getRuleByIdOrRuleId)({
    rulesClient,
    ruleId,
    id
  });
  if (existingRule == null) {
    const error = (0, _utils.getIdError)({
      id,
      ruleId
    });
    throw new _utils2.ClientError(error.message, error.statusCode);
  }
  (0, _validate.validateNonCustomizableUpdateFields)(ruleUpdate, existingRule);
  const ruleWithUpdates = await (0, _apply_rule_update.applyRuleUpdate)({
    prebuiltRuleAssetClient,
    existingRule,
    ruleUpdate
  });
  const updatedRule = await rulesClient.update({
    id: existingRule.id,
    data: (0, _convert_rule_response_to_alerting_rule.convertRuleResponseToAlertingRule)(ruleWithUpdates, actionsClient)
  });
  const {
    enabled
  } = await (0, _utils2.toggleRuleEnabledOnUpdate)(rulesClient, existingRule, ruleWithUpdates);
  return (0, _convert_alerting_rule_to_rule_response.convertAlertingRuleToRuleResponse)({
    ...updatedRule,
    enabled
  });
};
exports.updateRule = updateRule;