"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRule = void 0;
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _common = require("../../../../../../../common");
var _convert_alerting_rule_to_rule_response = require("../converters/convert_alerting_rule_to_rule_response");
var _convert_rule_response_to_alerting_rule = require("../converters/convert_rule_response_to_alerting_rule");
var _apply_rule_defaults = require("../mergers/apply_rule_defaults");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRule = async ({
  actionsClient,
  rulesClient,
  mlAuthz,
  rule,
  id,
  allowMissingConnectorSecrets
}) => {
  var _rule$enabled;
  await (0, _utils.validateMlAuth)(mlAuthz, rule.type);
  const ruleWithDefaults = (0, _apply_rule_defaults.applyRuleDefaults)(rule);
  const payload = {
    ...(0, _convert_rule_response_to_alerting_rule.convertRuleResponseToAlertingRule)(ruleWithDefaults, actionsClient),
    alertTypeId: _securitysolutionRules.ruleTypeMappings[rule.type],
    consumer: _common.SERVER_APP_ID,
    enabled: (_rule$enabled = rule.enabled) !== null && _rule$enabled !== void 0 ? _rule$enabled : false
  };
  const createdRule = await rulesClient.create({
    data: payload,
    options: {
      id
    },
    allowMissingConnectorSecrets
  });
  return (0, _convert_alerting_rule_to_rule_response.convertAlertingRuleToRuleResponse)(createdRule);
};
exports.createRule = createRule;