"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typeSpecificCamelToSnake = void 0;
var _utility_types = require("../../../../../../../common/utility_types");
var _object_case_converters = require("../../../../../../utils/object_case_converters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const typeSpecificCamelToSnake = params => {
  switch (params.type) {
    case 'eql':
      {
        return {
          type: params.type,
          language: params.language,
          index: params.index,
          data_view_id: params.dataViewId,
          query: params.query,
          filters: params.filters,
          timestamp_field: params.timestampField,
          event_category_override: params.eventCategoryOverride,
          tiebreaker_field: params.tiebreakerField,
          alert_suppression: params.alertSuppression ? (0, _object_case_converters.convertObjectKeysToSnakeCase)(params.alertSuppression) : undefined
        };
      }
    case 'esql':
      {
        return {
          type: params.type,
          language: params.language,
          query: params.query,
          alert_suppression: params.alertSuppression ? (0, _object_case_converters.convertObjectKeysToSnakeCase)(params.alertSuppression) : undefined
        };
      }
    case 'threat_match':
      {
        return {
          type: params.type,
          language: params.language,
          index: params.index,
          data_view_id: params.dataViewId,
          query: params.query,
          filters: params.filters,
          saved_id: params.savedId,
          threat_filters: params.threatFilters,
          threat_query: params.threatQuery,
          threat_mapping: params.threatMapping,
          threat_language: params.threatLanguage,
          threat_index: params.threatIndex,
          threat_indicator_path: params.threatIndicatorPath,
          concurrent_searches: params.concurrentSearches,
          items_per_search: params.itemsPerSearch,
          alert_suppression: params.alertSuppression ? (0, _object_case_converters.convertObjectKeysToSnakeCase)(params.alertSuppression) : undefined
        };
      }
    case 'query':
      {
        return {
          type: params.type,
          language: params.language,
          index: params.index,
          data_view_id: params.dataViewId,
          query: params.query,
          filters: params.filters,
          saved_id: params.savedId,
          alert_suppression: params.alertSuppression ? (0, _object_case_converters.convertObjectKeysToSnakeCase)(params.alertSuppression) : undefined
        };
      }
    case 'saved_query':
      {
        return {
          type: params.type,
          language: params.language,
          index: params.index,
          query: params.query,
          filters: params.filters,
          saved_id: params.savedId,
          data_view_id: params.dataViewId,
          alert_suppression: params.alertSuppression ? (0, _object_case_converters.convertObjectKeysToSnakeCase)(params.alertSuppression) : undefined
        };
      }
    case 'threshold':
      {
        var _params$alertSuppress, _params$alertSuppress2;
        return {
          type: params.type,
          language: params.language,
          index: params.index,
          data_view_id: params.dataViewId,
          query: params.query,
          filters: params.filters,
          saved_id: params.savedId,
          threshold: params.threshold,
          alert_suppression: (_params$alertSuppress = params.alertSuppression) !== null && _params$alertSuppress !== void 0 && _params$alertSuppress.duration ? {
            duration: (_params$alertSuppress2 = params.alertSuppression) === null || _params$alertSuppress2 === void 0 ? void 0 : _params$alertSuppress2.duration
          } : undefined
        };
      }
    case 'machine_learning':
      {
        return {
          type: params.type,
          anomaly_threshold: params.anomalyThreshold,
          machine_learning_job_id: params.machineLearningJobId,
          alert_suppression: params.alertSuppression ? (0, _object_case_converters.convertObjectKeysToSnakeCase)(params.alertSuppression) : undefined
        };
      }
    case 'new_terms':
      {
        return {
          type: params.type,
          query: params.query,
          new_terms_fields: params.newTermsFields,
          history_window_start: params.historyWindowStart,
          index: params.index,
          filters: params.filters,
          language: params.language,
          data_view_id: params.dataViewId,
          alert_suppression: params.alertSuppression ? (0, _object_case_converters.convertObjectKeysToSnakeCase)(params.alertSuppression) : undefined
        };
      }
    default:
      {
        return (0, _utility_types.assertUnreachable)(params);
      }
  }
};
exports.typeSpecificCamelToSnake = typeSpecificCamelToSnake;