"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installPrebuiltRulesPackage = installPrebuiltRulesPackage;
var _constants = require("../../../../../../common/detection_engine/constants");
var _find_latest_package_version = require("./find_latest_package_version");
var _ensure_installed_package = require("./ensure_installed_package");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Installs the prebuilt rules package of the config's specified or latest version.
 *
 * @param config Kibana config
 * @param context Request handler context
 */
async function installPrebuiltRulesPackage(context, logger) {
  const config = context.getConfig();
  let pkgVersion = config.prebuiltRulesPackageVersion;
  if (!pkgVersion) {
    logger.debug(`installPrebuiltRulesPackage: no package version specified in config.`);
    pkgVersion = await (0, _find_latest_package_version.findLatestPackageVersion)(context, _constants.PREBUILT_RULES_PACKAGE_NAME, logger);
  } else {
    logger.debug(`installPrebuiltRulesPackage: package version specified in config: ${pkgVersion}`);
  }
  return (0, _ensure_installed_package.ensureInstalledPackage)(context, _constants.PREBUILT_RULES_PACKAGE_NAME, pkgVersion, logger);
}