"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.revertPrebuiltRule = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _constants = require("../../constants");
var _revert_prebuilt_rule_handler = require("./revert_prebuilt_rule_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const revertPrebuiltRule = router => {
  router.versioned.post({
    access: 'internal',
    path: _prebuilt_rules.REVERT_PREBUILT_RULES_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      timeout: {
        idleSocket: _constants.PREBUILT_RULES_OPERATION_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_prebuilt_rules.RevertPrebuiltRulesRequest)
      }
    }
  }, _revert_prebuilt_rule_handler.revertPrebuiltRuleHandler);
};
exports.revertPrebuiltRule = revertPrebuiltRule;