"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertPickVersionIsTarget = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Assert that, in the case where the rule is undergoing a rule type change,
 * the pick_version value is set to 'TARGET' at all levels (global, rule-specific and field-specific)
 */
const assertPickVersionIsTarget = ({
  requestBody,
  ruleId
}) => {
  const pickVersions = [];
  if (requestBody.mode === 'SPECIFIC_RULES') {
    var _ref, _rulePayload$pick_ver;
    const rulePayload = requestBody.rules.find(rule => rule.rule_id === ruleId);

    // Rule-level pick_version overrides global pick_version. Pick rule-level pick_version if it
    // exists, otherwise use global pick_version. If none exist, we default to 'MERGED'.
    pickVersions.push((_ref = (_rulePayload$pick_ver = rulePayload === null || rulePayload === void 0 ? void 0 : rulePayload.pick_version) !== null && _rulePayload$pick_ver !== void 0 ? _rulePayload$pick_ver : requestBody.pick_version) !== null && _ref !== void 0 ? _ref : 'MERGED');
    if (rulePayload !== null && rulePayload !== void 0 && rulePayload.fields) {
      const fieldPickValues = Object.values(rulePayload === null || rulePayload === void 0 ? void 0 : rulePayload.fields).map(field => field.pick_version);
      pickVersions.push(...fieldPickValues);
    }
  } else {
    var _requestBody$pick_ver;
    // mode: ALL_RULES
    pickVersions.push((_requestBody$pick_ver = requestBody.pick_version) !== null && _requestBody$pick_ver !== void 0 ? _requestBody$pick_ver : 'MERGED');
  }
  const allPickVersionsAreTarget = pickVersions.every(version => version === 'TARGET');

  // If pick_version is provided at any levels, they must all be set to 'TARGET'
  if (!allPickVersionsAreTarget) {
    throw new Error(`Rule update for rule ${ruleId} has a rule type change. All 'pick_version' values for rule must match 'TARGET'`);
  }
};
exports.assertPickVersionIsTarget = assertPickVersionIsTarget;