"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performRuleInstallationRoute = void 0;
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _route_validation = require("../../../../../utils/build_validation/route_validation");
var _constants = require("../../constants");
var _route_limited_concurrency_tag = require("../../../../../utils/route_limited_concurrency_tag");
var _perform_rule_installation_handler = require("./perform_rule_installation_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const performRuleInstallationRoute = (router, logger) => {
  router.versioned.post({
    access: 'internal',
    path: _prebuilt_rules.PERFORM_RULE_INSTALLATION_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      tags: [(0, _route_limited_concurrency_tag.routeLimitedConcurrencyTag)(_constants.PREBUILT_RULES_OPERATION_CONCURRENCY)],
      timeout: {
        idleSocket: _constants.PREBUILT_RULES_OPERATION_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidation)(_prebuilt_rules.PerformRuleInstallationRequestBody)
      }
    }
  }, (context, request, response) => {
    return (0, _perform_rule_installation_handler.performRuleInstallationHandler)(context, request, response, logger);
  });
};
exports.performRuleInstallationRoute = performRuleInstallationRoute;