"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsClientFactory = exports.InternalReadonlySoClientMethodNotAllowedError = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
var _common = require("@kbn/spaces-plugin/common");
var _errors = require("../../../../common/endpoint/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/no-explicit-any,max-classes-per-file */

const RESTRICTED_METHODS = ['bulkCreate', 'bulkUpdate', 'create', 'createPointInTimeFinder', 'delete', 'removeReferencesTo', 'update', 'updateObjectsSpaces'];
class InternalReadonlySoClientMethodNotAllowedError extends _errors.EndpointError {}

/**
 * Factory service for accessing saved object clients
 */
exports.InternalReadonlySoClientMethodNotAllowedError = InternalReadonlySoClientMethodNotAllowedError;
class SavedObjectsClientFactory {
  constructor(savedObjectsServiceStart, httpServiceSetup) {
    this.savedObjectsServiceStart = savedObjectsServiceStart;
    this.httpServiceSetup = httpServiceSetup;
  }
  createFakeHttpRequest(spaceId = _common.DEFAULT_SPACE_ID) {
    const fakeRequest = (0, _coreHttpServerUtils.kibanaRequestFactory)({
      headers: {},
      path: '/',
      route: {
        settings: {}
      },
      url: {
        href: {},
        hash: ''
      },
      raw: {
        req: {
          url: '/'
        }
      }
    });
    if (spaceId && spaceId !== _common.DEFAULT_SPACE_ID) {
      this.httpServiceSetup.basePath.set(fakeRequest, (0, _common.addSpaceIdToPath)('/', spaceId));
    }
    return fakeRequest;
  }
  toReadonly(soClient) {
    return new Proxy(soClient, {
      get(target, methodName, receiver) {
        if (RESTRICTED_METHODS.includes(methodName)) {
          throw new InternalReadonlySoClientMethodNotAllowedError(`Method [${methodName}] not allowed on internal readonly SO Client`);
        }
        return Reflect.get(target, methodName, receiver);
      }
    });
  }

  /**
   * Creates a SavedObjects client that is scoped to a space (default: `Default`)
   */
  createInternalScopedSoClient({
    spaceId = _common.DEFAULT_SPACE_ID,
    readonly = true
  } = {}) {
    const soClient = this.savedObjectsServiceStart.getScopedClient(this.createFakeHttpRequest(spaceId), {
      excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID]
    });
    if (readonly) {
      return this.toReadonly(soClient);
    }
    return soClient;
  }

  /**
   * Create a SavedObjects client that is un-scoped to a space and thus can access all
   * data across all spaces.
   *
   * **WARNING:** Use with care!
   */
  createInternalUnscopedSoClient(readonly = true) {
    const soClient = this.savedObjectsServiceStart.getScopedClient(this.createFakeHttpRequest(), {
      excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID, _coreSavedObjectsServer.SPACES_EXTENSION_ID]
    });
    if (readonly) {
      return this.toReadonly(soClient);
    }
    return soClient;
  }
}
exports.SavedObjectsClientFactory = SavedObjectsClientFactory;