"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolverEntity = resolverEntity;
var _supported_schemas = require("./supported_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toArray = input => [].concat(input);
function resolverEntity(hits, experimentalFeatures) {
  const responseBody = [];
  const supportedSchemas = (0, _supported_schemas.getSupportedSchemas)(experimentalFeatures);
  for (const hit of hits) {
    for (const supportedSchema of supportedSchemas) {
      let foundSchema = true;
      // check that the constraint and id fields are defined and that the id field is not an empty string
      const id = (0, _supported_schemas.getFieldAsString)(hit._source, supportedSchema.schema.id);
      const agentId = supportedSchema.schema.agentId && (0, _supported_schemas.getFieldAsString)(hit._source, supportedSchema.schema.agentId);
      for (const constraint of supportedSchema.constraints) {
        const fieldValue = (0, _supported_schemas.getFieldAsString)(hit._source, constraint.field);
        // track that all the constraints are true, if one of them is false then this schema is not valid so mark it
        // that we did not find the schema

        foundSchema = foundSchema && toArray(constraint.value).some(constraintValue => constraintValue.toLowerCase() === (fieldValue === null || fieldValue === void 0 ? void 0 : fieldValue.toLowerCase()));
      }
      if (foundSchema && id !== undefined && id !== '') {
        responseBody.push({
          name: supportedSchema.name,
          schema: supportedSchema.schema,
          id,
          ...(agentId ? {
            agentId
          } : {})
        });
      }
    }
  }
  return responseBody;
}