"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectIndexPattern = void 0;
var _langgraph = require("@langchain/langgraph");
var _messages = require("@langchain/core/messages");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSelectIndexPattern = ({
  identifyIndexGraph
}) => {
  return async state => {
    const childGraphOutput = await identifyIndexGraph.invoke({
      input: state.input
    });
    if (!childGraphOutput.selectedIndexPattern) {
      return new _langgraph.Command({
        goto: _constants.NL_TO_ESQL_AGENT_WITHOUT_VALIDATION_NODE
      });
    }
    const context = childGraphOutput.selectedIndexPattern in childGraphOutput.indexPatternAnalysis ? childGraphOutput.indexPatternAnalysis[childGraphOutput.selectedIndexPattern].context : undefined;
    return new _langgraph.Command({
      update: {
        selectedIndexPattern: childGraphOutput.selectedIndexPattern,
        messages: [new _messages.HumanMessage({
          content: `We have analyzed multiple index patterns to see if they contain the data required for the query. The following index pattern should be used for the query verbatim: '${childGraphOutput.selectedIndexPattern}'.\n` + `Some context about the index mapping:\n\n${context ? context : ''}`
        })]
      }
    });
  };
};
exports.getSelectIndexPattern = getSelectIndexPattern;