"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIncompatibleVirusOutputParser = getIncompatibleVirusOutputParser;
var _output_parsers = require("langchain/output_parsers");
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIncompatibleVirusOutputParser() {
  return _output_parsers.StructuredOutputParser.fromZodSchema(_zod.z.array(_zod.z.object({
    group: _zod.z.string().describe('The program which is triggering the events'),
    events: _zod.z.object({
      id: _zod.z.string().describe('The event ID'),
      endpointId: _zod.z.string().describe('The endpoint ID'),
      value: _zod.z.string().describe('The process.executable value of the event')
    }).array().describe('The events that the insight is based on')
  })));
}