"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateTimeline = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../common/store/inputs/constants");
var _store = require("../store");
var _use_full_screen = require("../../common/containers/use_full_screen");
var _timeline = require("../../../common/types/timeline");
var _timeline2 = require("../../../common/api/timeline");
var _use_selector = require("../../common/hooks/use_selector");
var _inputs = require("../../common/store/inputs");
var _app = require("../../common/store/app");
var _use_discover_in_timeline_context = require("../../common/components/discover_in_timeline/use_discover_in_timeline_context");
var _default_headers = require("../components/timeline/body/column_headers/default_headers");
var _defaults = require("../store/defaults");
var _use_select_data_view = require("../../data_view_manager/hooks/use_select_data_view");
var _constants2 = require("../../data_view_manager/constants");
var _store2 = require("../../sourcerer/store");
var _model = require("../../sourcerer/store/model");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _use_security_default_patterns = require("../../data_view_manager/hooks/use_security_default_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a new empty timeline for the given id and type.
 * Can be used to create new timelines or to reset timeline state.
 * It allows a callback to be passed in to be called when the timeline is created.
 */
const useCreateTimeline = ({
  timelineId,
  timelineType,
  onClick
}) => {
  var _useSelector;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    id: oldDataViewId,
    patternList: oldSelectedPatterns
  } = (_useSelector = (0, _reactRedux.useSelector)(_store2.sourcererSelectors.defaultDataView)) !== null && _useSelector !== void 0 ? _useSelector : {
    id: '',
    patternList: []
  };
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const {
    id: experimentalSecurityDefaultDataViewId,
    indexPatterns: experimentalSecurityDefaultIndexPatterns
  } = (0, _use_security_default_patterns.useSecurityDefaultPatterns)();
  const dataViewId = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalSecurityDefaultDataViewId !== null && experimentalSecurityDefaultDataViewId !== void 0 ? experimentalSecurityDefaultDataViewId : '' : oldDataViewId, [experimentalSecurityDefaultDataViewId, newDataViewPickerEnabled, oldDataViewId]);
  const selectedPatterns = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalSecurityDefaultIndexPatterns : oldSelectedPatterns, [experimentalSecurityDefaultIndexPatterns, newDataViewPickerEnabled, oldSelectedPatterns]);
  const {
    timelineFullScreen,
    setTimelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const globalTimeRange = (0, _use_selector.useDeepEqualSelector)(_inputs.inputsSelectors.globalTimeRangeSelector);
  const {
    resetDiscoverAppState
  } = (0, _use_discover_in_timeline_context.useDiscoverInTimelineContext)();
  const setSelectedDataView = (0, _use_select_data_view.useSelectDataView)();
  const createTimeline = (0, _react.useCallback)(({
    id,
    show,
    timeRange: timeRangeParam
  }) => {
    const timerange = timeRangeParam !== null && timeRangeParam !== void 0 ? timeRangeParam : globalTimeRange;
    if (id === _timeline.TimelineId.active && timelineFullScreen) {
      setTimelineFullScreen(false);
    }
    setSelectedDataView({
      id: dataViewId,
      fallbackPatterns: selectedPatterns,
      scope: _constants2.DataViewManagerScopeName.timeline
    });
    dispatch(_store2.sourcererActions.setSelectedDataView({
      id: _model.SourcererScopeName.timeline,
      selectedDataViewId: dataViewId,
      selectedPatterns
    }));
    dispatch(_store.timelineActions.createTimeline({
      columns: _default_headers.defaultUdtHeaders,
      dataViewId,
      id,
      indexNames: selectedPatterns,
      show,
      timelineType,
      updated: undefined,
      excludedRowRendererIds: timelineType !== _timeline2.TimelineTypeEnum.template ? _defaults.timelineDefaults.excludedRowRendererIds : []
    }));
    dispatch(_inputs.inputsActions.addLinkTo([_constants.InputsModelId.global, _constants.InputsModelId.timeline]));
    dispatch(_app.appActions.addNotes({
      notes: []
    }));
    if (timeRangeParam) {
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.timeline, _constants.InputsModelId.global]));
    }
    if ((timerange === null || timerange === void 0 ? void 0 : timerange.kind) === 'absolute') {
      dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
        ...timerange,
        id: _constants.InputsModelId.timeline
      }));
    } else if ((timerange === null || timerange === void 0 ? void 0 : timerange.kind) === 'relative') {
      dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
        ...timerange,
        id: _constants.InputsModelId.timeline
      }));
    }
  }, [globalTimeRange, timelineFullScreen, dispatch, dataViewId, selectedPatterns, setSelectedDataView, timelineType, setTimelineFullScreen]);
  return (0, _react.useCallback)(async options => {
    await resetDiscoverAppState();
    createTimeline({
      id: timelineId,
      show: true,
      timeRange: options === null || options === void 0 ? void 0 : options.timeRange
    });
    if (typeof onClick === 'function') {
      onClick();
    }
  }, [createTimeline, timelineId, onClick, resetDiscoverAppState]);
};
exports.useCreateTimeline = useCreateTimeline;