"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineEventsHandler = exports.useTimelineEvents = exports.initSortDefault = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _fp = require("lodash/fp");
var _react = require("react");
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _kibana = require("../../common/lib/kibana");
var _helpers = require("../../common/containers/helpers");
var _store = require("../store");
var _helpers2 = require("./helpers");
var _helpers3 = require("../../helpers");
var _search_strategy = require("../../../common/search_strategy");
var _timeline = require("../../../common/types/timeline");
var _use_route_spy = require("../../common/utils/route/use_route_spy");
var _active_timeline_context = require("./active_timeline_context");
var _use_track_http_request = require("../../common/lib/apm/use_track_http_request");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineEvents = timelineEdges => timelineEdges.map(e => e.node);
const ID = 'timelineEventsQuery';
const initSortDefault = exports.initSortDefault = [{
  field: '@timestamp',
  direction: _search_strategy.Direction.asc,
  type: 'date',
  esTypes: ['date']
}];
const deStructureEqlOptions = eqlOptions => ({
  ...(!(0, _fp.isEmpty)(eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.eventCategoryField) ? {
    eventCategoryField: eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.eventCategoryField
  } : {}),
  ...(!(0, _fp.isEmpty)(eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.size) ? {
    size: eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.size
  } : {}),
  ...(!(0, _fp.isEmpty)(eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.tiebreakerField) ? {
    tiebreakerField: eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.tiebreakerField
  } : {}),
  ...(!(0, _fp.isEmpty)(eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.timestampField) ? {
    timestampField: eqlOptions === null || eqlOptions === void 0 ? void 0 : eqlOptions.timestampField
  } : {})
});
const useTimelineEventsHandler = ({
  dataViewId,
  endDate,
  eqlOptions = undefined,
  id = ID,
  indexNames,
  fields,
  filterQuery,
  runtimeMappings,
  startDate,
  language = 'kuery',
  limit,
  sort = initSortDefault,
  skip = false,
  timerangeKind
}) => {
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const searchSubscription$ = (0, _react.useRef)(new _rxjs.Subscription());
  const [loading, setLoading] = (0, _react.useState)(_unifiedDataTable.DataLoadingState.loaded);
  const [activeBatch, setActiveBatch] = (0, _react.useState)(id === _timeline.TimelineId.active ? _active_timeline_context.activeTimeline.getActivePage() : 0);
  const [timelineRequest, setTimelineRequest] = (0, _react.useState)(null);
  const prevTimelineRequest = (0, _react.useRef)(null);
  const {
    startTracking
  } = (0, _use_track_http_request.useTrackHttpRequest)();
  const clearSignalsState = (0, _react.useCallback)(() => {
    if (id != null && _helpers2.detectionsTimelineIds.some(timelineId => timelineId === id)) {
      dispatch(_store.timelineActions.clearEventsLoading({
        id
      }));
      dispatch(_store.timelineActions.clearEventsDeleted({
        id
      }));
    }
  }, [dispatch, id]);

  /**
   * `loadBatchHandler` loads the next batch of records.
   * This is different from the data grid pages. Data grid pagination is only
   * client side and changing data grid pages does not impact this function.
   *
   * When user manually requests next batch of records, then a next batch is fetched
   * irrespective of where user is in Data grid pagination.
   *
   */
  const loadBatchHandler = (0, _react.useCallback)(newActiveBatch => {
    clearSignalsState();
    if (id === _timeline.TimelineId.active) {
      _active_timeline_context.activeTimeline.setActivePage(newActiveBatch);
    }
    setActiveBatch(newActiveBatch);
  }, [clearSignalsState, id]);
  const loadNextBatch = (0, _react.useCallback)(() => {
    loadBatchHandler(activeBatch + 1);
  }, [activeBatch, loadBatchHandler]);
  (0, _react.useEffect)(() => {
    return () => {
      var _searchSubscription$$;
      (_searchSubscription$$ = searchSubscription$.current) === null || _searchSubscription$$ === void 0 ? void 0 : _searchSubscription$$.unsubscribe();
    };
  }, []);
  (0, _react.useEffect)(() => {
    // when batch size changes, refetch DataGrid
    setActiveBatch(0);
  }, [limit]);
  const defaultTimelineResponse = (0, _react.useMemo)(() => ({
    id,
    inspect: {
      dsl: [],
      response: []
    },
    refetch: () => {},
    totalCount: -1,
    pageInfo: {
      activePage: 0,
      querySize: 0
    },
    events: [],
    loadNextBatch,
    refreshedAt: 0
  }), [id, loadNextBatch]);
  const [timelineResponse, setTimelineResponse] = (0, _react.useState)(defaultTimelineResponse);
  const timelineSearch = (0, _react.useCallback)(async (request, onNextHandler) => {
    if (request == null || pageName === '' || skip) {
      return;
    }
    const asyncSearch = async () => {
      prevTimelineRequest.current = request;
      abortCtrl.current = new AbortController();
      if (activeBatch === 0) {
        setLoading(_unifiedDataTable.DataLoadingState.loading);
      } else {
        setLoading(_unifiedDataTable.DataLoadingState.loadingMore);
      }
      const {
        endTracking
      } = startTracking({
        name: `${_constants.APP_UI_ID} timeline events search`
      });
      searchSubscription$.current = data.search.search(request, {
        strategy: request.language === 'eql' ? 'timelineEqlSearchStrategy' : 'timelineSearchStrategy',
        abortSignal: abortCtrl.current.signal,
        // we only need the id to throw better errors
        indexPattern: {
          id: dataViewId
        }
      }).subscribe({
        next: response => {
          if (!(0, _common.isRunningResponse)(response)) {
            endTracking('success');
            setLoading(_unifiedDataTable.DataLoadingState.loaded);
            setTimelineResponse(prevResponse => {
              const newTimelineResponse = {
                ...prevResponse,
                /**/
                events: getTimelineEvents(response.edges),
                inspect: (0, _helpers3.getInspectResponse)(response, prevResponse.inspect),
                pageInfo: response.pageInfo,
                totalCount: response.totalCount,
                refreshedAt: Date.now()
              };
              if (id === _timeline.TimelineId.active) {
                _active_timeline_context.activeTimeline.setPageName(pageName);
                if (request.language === 'eql') {
                  _active_timeline_context.activeTimeline.setEqlRequest(request);
                  _active_timeline_context.activeTimeline.setEqlResponse(newTimelineResponse);
                } else {
                  _active_timeline_context.activeTimeline.setRequest(request);
                  _active_timeline_context.activeTimeline.setResponse(newTimelineResponse);
                }
              }
              if (onNextHandler) onNextHandler(newTimelineResponse);
              return newTimelineResponse;
            });
            searchSubscription$.current.unsubscribe();
          }
        },
        error: msg => {
          endTracking(abortCtrl.current.signal.aborted ? 'aborted' : 'error');
          setLoading(_unifiedDataTable.DataLoadingState.loaded);
          data.search.showError(msg);
          searchSubscription$.current.unsubscribe();
        }
      });
    };
    if (id === _timeline.TimelineId.active && _active_timeline_context.activeTimeline.getPageName() !== '' && pageName !== _active_timeline_context.activeTimeline.getPageName()) {
      _active_timeline_context.activeTimeline.setPageName(pageName);
      abortCtrl.current.abort();
      setLoading(_unifiedDataTable.DataLoadingState.loaded);
      if (request.language === 'eql') {
        prevTimelineRequest.current = _active_timeline_context.activeTimeline.getEqlRequest();
      } else {
        prevTimelineRequest.current = _active_timeline_context.activeTimeline.getRequest();
      }
      setTimelineResponse(prevResp => {
        const resp = request.language === 'eql' ? _active_timeline_context.activeTimeline.getEqlResponse() : _active_timeline_context.activeTimeline.getResponse();
        if (resp != null) {
          return resp;
        }
        return prevResp;
      });
      if (request.language !== 'eql' && _active_timeline_context.activeTimeline.getResponse() != null) {
        return;
      } else if (request.language === 'eql' && _active_timeline_context.activeTimeline.getEqlResponse() != null) {
        return;
      }
    }
    searchSubscription$.current.unsubscribe();
    abortCtrl.current.abort();
    await asyncSearch();
  }, [pageName, skip, id, activeBatch, startTracking, data.search, dataViewId]);
  const refetchPagination = (0, _react.useMemo)(() => {
    return {
      activePage: 0,
      querySize: limit
    };
  }, [limit]);
  const refetchGrid = (0, _react.useCallback)(() => {
    var _timelineRequest$fiel, _timelineRequest$fiel2;
    /*
     *
     * Trigger search with a new request object to fetch the latest data.
     *
     */
    const newTimelineRequest = {
      ...timelineRequest,
      factoryQueryType: _search_strategy.TimelineEventsQueries.all,
      language,
      sort,
      fieldRequested: (_timelineRequest$fiel = timelineRequest === null || timelineRequest === void 0 ? void 0 : timelineRequest.fieldRequested) !== null && _timelineRequest$fiel !== void 0 ? _timelineRequest$fiel : fields,
      fields: (_timelineRequest$fiel2 = timelineRequest === null || timelineRequest === void 0 ? void 0 : timelineRequest.fieldRequested) !== null && _timelineRequest$fiel2 !== void 0 ? _timelineRequest$fiel2 : fields,
      pagination: refetchPagination
    };
    setTimelineRequest(newTimelineRequest);
    timelineSearch(newTimelineRequest);
    setActiveBatch(0);
  }, [timelineRequest, timelineSearch, refetchPagination, language, sort, fields]);
  (0, _react.useEffect)(() => {
    if (indexNames.length === 0) {
      return;
    }

    // Only set timeline request when an actual query exists
    if (filterQuery || eqlOptions !== null && eqlOptions !== void 0 && eqlOptions.query) {
      setTimelineRequest(prevRequest => {
        var _prevRequest$defaultI, _prevRequest$filterQu, _prevRequest$sort, _prevRequest$timerang, _prevRequest$runtimeM;
        const prevEqlRequest = prevRequest;
        const prevSearchParameters = {
          defaultIndex: (_prevRequest$defaultI = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.defaultIndex) !== null && _prevRequest$defaultI !== void 0 ? _prevRequest$defaultI : [],
          filterQuery: (_prevRequest$filterQu = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.filterQuery) !== null && _prevRequest$filterQu !== void 0 ? _prevRequest$filterQu : '',
          sort: (_prevRequest$sort = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.sort) !== null && _prevRequest$sort !== void 0 ? _prevRequest$sort : initSortDefault,
          timerange: (_prevRequest$timerang = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.timerange) !== null && _prevRequest$timerang !== void 0 ? _prevRequest$timerang : {},
          runtimeMappings: (_prevRequest$runtimeM = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.runtimeMappings) !== null && _prevRequest$runtimeM !== void 0 ? _prevRequest$runtimeM : {},
          ...deStructureEqlOptions(prevEqlRequest)
        };
        const timerange = startDate && endDate ? {
          timerange: {
            interval: '12h',
            from: startDate,
            to: endDate
          }
        } : {};
        const currentSearchParameters = {
          defaultIndex: indexNames,
          filterQuery: (0, _helpers.createFilter)(filterQuery),
          sort,
          runtimeMappings: runtimeMappings !== null && runtimeMappings !== void 0 ? runtimeMappings : {},
          ...timerange,
          ...deStructureEqlOptions(eqlOptions)
        };
        const areSearchParamsSame = (0, _fastDeepEqual.default)(prevSearchParameters, currentSearchParameters);
        const newActiveBatch = !areSearchParamsSame ? 0 : activeBatch;

        /*
         * optimization to avoid unnecessary network request when a field
         * has already been fetched
         *
         */

        let finalFieldRequest = fields;
        const newFieldsRequested = fields.filter(field => {
          var _prevRequest$fieldReq;
          return !(prevRequest !== null && prevRequest !== void 0 && (_prevRequest$fieldReq = prevRequest.fieldRequested) !== null && _prevRequest$fieldReq !== void 0 && _prevRequest$fieldReq.includes(field));
        });
        if (newFieldsRequested.length > 0) {
          var _prevRequest$fieldReq2;
          finalFieldRequest = [...((_prevRequest$fieldReq2 = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.fieldRequested) !== null && _prevRequest$fieldReq2 !== void 0 ? _prevRequest$fieldReq2 : []), ...newFieldsRequested];
        } else {
          var _prevRequest$fieldReq3;
          finalFieldRequest = (_prevRequest$fieldReq3 = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.fieldRequested) !== null && _prevRequest$fieldReq3 !== void 0 ? _prevRequest$fieldReq3 : [];
        }
        let newPagination = {
          /*
           *
           * fetches data cumulatively for the batches upto the activeBatch
           * This is needed because, we want to get incremental data as well for the old batches
           * For example, newly requested fields
           *
           * */
          activePage: newActiveBatch,
          querySize: limit
        };
        if (newFieldsRequested.length > 0) {
          newPagination = {
            activePage: 0,
            querySize: (newActiveBatch + 1) * limit
          };
        }
        const currentRequest = {
          defaultIndex: indexNames,
          factoryQueryType: _search_strategy.TimelineEventsQueries.all,
          fieldRequested: finalFieldRequest,
          fields: finalFieldRequest,
          filterQuery: (0, _helpers.createFilter)(filterQuery),
          pagination: newPagination,
          language,
          runtimeMappings,
          sort,
          ...timerange,
          ...(eqlOptions ? eqlOptions : {})
        };
        if (activeBatch !== newActiveBatch) {
          setActiveBatch(newActiveBatch);
          if (id === _timeline.TimelineId.active) {
            _active_timeline_context.activeTimeline.setActivePage(newActiveBatch);
          }
        }
        if (!(0, _fastDeepEqual.default)(prevRequest, currentRequest)) {
          return currentRequest;
        }
        return prevRequest;
      });
    }
  }, [dispatch, indexNames, activeBatch, endDate, eqlOptions, filterQuery, id, language, limit, startDate, sort, fields, runtimeMappings]);

  /*
    cleanup timeline events response when the filters were removed completely
    to avoid displaying previous query results
  */
  (0, _react.useEffect)(() => {
    if ((0, _fp.isEmpty)(filterQuery)) {
      setTimelineResponse(defaultTimelineResponse);
    }
  }, [defaultTimelineResponse, filterQuery]);
  const timelineSearchHandler = (0, _react.useCallback)(async onNextHandler => {
    if (id !== _timeline.TimelineId.active || timerangeKind === 'absolute' || !(0, _fastDeepEqual.default)(prevTimelineRequest.current, timelineRequest)) {
      await timelineSearch(timelineRequest, onNextHandler);
    }
  }, [id, timelineRequest, timelineSearch, timerangeKind]);
  const finalTimelineLineResponse = (0, _react.useMemo)(() => {
    return {
      ...timelineResponse,
      loadNextBatch,
      refetch: refetchGrid
    };
  }, [timelineResponse, loadNextBatch, refetchGrid]);
  return [loading, finalTimelineLineResponse, timelineSearchHandler];
};
exports.useTimelineEventsHandler = useTimelineEventsHandler;
const defaultEvents = [];
const useTimelineEvents = ({
  dataViewId,
  endDate,
  eqlOptions = undefined,
  id = ID,
  indexNames,
  fields,
  filterQuery,
  runtimeMappings,
  startDate,
  language = 'kuery',
  limit,
  sort = initSortDefault,
  skip = false,
  timerangeKind
}) => {
  const [eventsPerPage, setEventsPerPage] = (0, _react.useState)(defaultEvents);
  const [dataLoadingState, timelineResponse, timelineSearchHandler] = useTimelineEventsHandler({
    dataViewId,
    endDate,
    eqlOptions,
    id,
    indexNames,
    fields,
    filterQuery,
    runtimeMappings,
    startDate,
    language,
    limit,
    sort,
    skip,
    timerangeKind
  });
  (0, _react.useEffect)(() => {
    /*
     * `timelineSearchHandler` only returns the events for the current page.
     * This effect is responsible for storing the events for each page so that
     * the combined list of events can be supplied to DataGrid.
     *
     * */

    if (dataLoadingState !== _unifiedDataTable.DataLoadingState.loaded) return;
    const {
      activePage,
      querySize
    } = timelineResponse.pageInfo;
    setEventsPerPage(prev => {
      let result = structuredClone(prev);
      const newEventsLength = timelineResponse.events.length;
      const oldEventsLength = result.length;
      if (querySize === limit && activePage > 0) {
        result[activePage] = timelineResponse.events;
      } else if (oldEventsLength === 0 && newEventsLength === 0) {
        // don't change array reference if no actual changes take place
        result = prev;
      } else {
        result = [timelineResponse.events];
      }
      return result;
    });
  }, [timelineResponse.events, timelineResponse.pageInfo, dataLoadingState, limit]);
  (0, _react.useEffect)(() => {
    if (!timelineSearchHandler) return;
    timelineSearchHandler();
  }, [timelineSearchHandler]);
  const combinedEvents = (0, _react.useMemo)(
  // exclude undefined values / empty slots
  () => eventsPerPage.filter(Boolean).flat(), [eventsPerPage]);
  const combinedResponse = (0, _react.useMemo)(() => ({
    ...timelineResponse,
    events: combinedEvents
  }), [timelineResponse, combinedEvents]);
  return [dataLoadingState, combinedResponse];
};
exports.useTimelineEvents = useTimelineEvents;