"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineEventsDetails = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/timelines-plugin/common");
var _kibana = require("../../../common/lib/kibana");
var _search_strategy = require("../../../../common/search_strategy");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineEventsDetails = ({
  entityType = _common2.EntityType.EVENTS,
  indexName,
  eventId,
  runtimeMappings,
  skip
}) => {
  const asyncNoop = () => Promise.resolve();
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const refetch = (0, _react.useRef)(asyncNoop);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const searchSubscription$ = (0, _react.useRef)(new _rxjs.Subscription());

  // loading = false initial state causes flashes of empty tables
  const [loading, setLoading] = (0, _react.useState)(true);
  const [timelineDetailsRequest, setTimelineDetailsRequest] = (0, _react.useState)(null);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [timelineDetailsResponse, setTimelineDetailsResponse] = (0, _react.useState)(null);
  const [ecsData, setEcsData] = (0, _react.useState)(null);
  const [rawEventData, setRawEventData] = (0, _react.useState)(undefined);
  const timelineDetailsSearch = (0, _react.useCallback)(request => {
    if (request == null || skip || (0, _fp.isEmpty)(request.eventId)) {
      return;
    }
    const asyncSearch = async () => {
      abortCtrl.current = new AbortController();
      setLoading(true);
      searchSubscription$.current = data.search.search(request, {
        strategy: 'timelineSearchStrategy',
        abortSignal: abortCtrl.current.signal
      }).subscribe({
        next: response => {
          if (!(0, _common.isRunningResponse)(response)) {
            Promise.resolve().then(() => {
              _reactDom.default.unstable_batchedUpdates(() => {
                setLoading(false);
                setTimelineDetailsResponse(response.data || []);
                setRawEventData(response.rawResponse.hits.hits[0]);
                setEcsData(response.ecs || null);
                searchSubscription$.current.unsubscribe();
              });
            });
          }
        },
        error: msg => {
          setLoading(false);
          addError(msg, {
            title: i18n.FAIL_TIMELINE_SEARCH_DETAILS
          });
          searchSubscription$.current.unsubscribe();
        }
      });
    };
    searchSubscription$.current.unsubscribe();
    abortCtrl.current.abort();
    asyncSearch();
    refetch.current = asyncSearch;
  }, [data.search, addError, skip]);
  (0, _react.useEffect)(() => {
    setTimelineDetailsRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        entityType,
        indexName,
        eventId,
        factoryQueryType: _search_strategy.TimelineEventsQueries.details,
        runtimeMappings
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [entityType, eventId, indexName, runtimeMappings]);
  (0, _react.useEffect)(() => {
    timelineDetailsSearch(timelineDetailsRequest);
    return () => {
      searchSubscription$.current.unsubscribe();
      abortCtrl.current.abort();
    };
  }, [timelineDetailsRequest, timelineDetailsSearch]);
  return [loading, timelineDetailsResponse, rawEventData, ecsData, refetch.current];
};
exports.useTimelineEventsDetails = useTimelineEventsDetails;