"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userProfileColumnRenderer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _users_avatars_panel = require("../../../../../common/components/user_profiles/users_avatars_panel");
var _fetch_page_context = require("../../../../../detections/configurations/security_solution_detections/fetch_page_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const userProfileColumnRenderer = exports.userProfileColumnRenderer = {
  isInstance: (columnName, _, context) => _fetch_page_context.profileUidColumns.includes(columnName) && !!context,
  renderColumn: ({
    values,
    context
  }) => {
    var _values$map;
    // Show spinner if loading profiles or if there are no fetched profiles yet
    // Do not show the loading spinner if context is not provided at all
    if (context !== null && context !== void 0 && context.isLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "s"
      });
    }
    const userProfiles = (_values$map = values === null || values === void 0 ? void 0 : values.map(uid => {
      var _context$profiles;
      return context === null || context === void 0 ? void 0 : (_context$profiles = context.profiles) === null || _context$profiles === void 0 ? void 0 : _context$profiles.find(user => uid === user.uid);
    })) !== null && _values$map !== void 0 ? _values$map : [];
    return /*#__PURE__*/_react.default.createElement(_users_avatars_panel.UsersAvatarsPanel, {
      userProfiles: userProfiles,
      maxVisibleAvatars: 4
    });
  }
};