"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WITH_RESULT = exports.WITH_EXIT_CODE = exports.WAS_PREVENTED_FROM_RENAMING_A_MALICIOUS_FILE = exports.WAS_PREVENTED_FROM_MODIFYING_A_MALICIOUS_FILE = exports.WAS_PREVENTED_FROM_EXECUTING_A_MALICIOUS_PROCESS = exports.WAS_PREVENTED_FROM_CREATING_A_MALICIOUS_FILE = exports.WAS_DETECTED_RENAMING_A_MALICIOUS_FILE = exports.WAS_DETECTED_MODIFYING_A_MALICIOUS_FILE = exports.WAS_DETECTED_EXECUTING_A_MALICIOUS_PROCESS = exports.WAS_DETECTED_CREATING_A_MALICIOUS_FILE = exports.VIA_PARENT_PROCESS = exports.VIA = exports.USING = exports.USER_REMOVED = exports.USER_CHANGED = exports.USER_ADDED = exports.TERMINATED_PROCESS = exports.SOCKET_OPENED = exports.SOCKET_CLOSED = exports.RENAMED_FILE = exports.RANSOMWARE_WAS_PREVENTED_FROM_ENCRYPTING_FILES = exports.RANSOMWARE_WAS_DETECTED_ENCRYPTING_FILES = exports.PROCESS_STOPPED = exports.PROCESS_STARTED = exports.PROCESS_ERROR = exports.PACKAGE_UPDATED = exports.PACKAGE_REMOVED = exports.PACKAGE_INSTALLED = exports.OVERWROTE_FILE = exports.MODIFIED_REGISTRY_KEY = exports.MODIFIED_FILE = exports.MADE_A_HTTP_REQUEST_VIA = exports.LOGGED_OUT = exports.LOADED_LIBRARY = exports.INVALID = exports.HOST_CHANGED = exports.FORKED_PROCESS = exports.EXISTING_USER = exports.EXISTING_SOCKET = exports.EXISTING_PROCESS = exports.EXISTING_PACKAGE = exports.EXECUTED_PROCESS = exports.ERROR = exports.DISCONNECTED_VIA = exports.DELETED_FILE = exports.CREATED_FILE = exports.BOOT = exports.ATTEMPTED_LOGIN = exports.ACCEPTED_A_CONNECTION_VIA = exports.ACCEPTED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Note for translators and programmers
// Examples of these strings are all of the form
// Session {user.name}@{hostname} in {folder} was authorized to use {executable} with result {result.success/failure}
// E.x. Frank@server-1 in /root was authorized to use wget with result success

// However, the strings can be dropped depending on the circumstances of the variables. For example, with no data at all
// Example with just a user name and hostname
// Session 20 frank@server-1
// Example with user name, hostname, but no result
// Session 20 frank@server-1 started process curl

const WITH_RESULT = exports.WITH_RESULT = _i18n.i18n.translate('xpack.securitySolution.system.withResultDescription', {
  defaultMessage: 'with result'
});
const ACCEPTED_A_CONNECTION_VIA = exports.ACCEPTED_A_CONNECTION_VIA = _i18n.i18n.translate('xpack.securitySolution.system.acceptedAConnectionViaDescription', {
  defaultMessage: 'accepted a connection via'
});
const ATTEMPTED_LOGIN = exports.ATTEMPTED_LOGIN = _i18n.i18n.translate('xpack.securitySolution.system.attemptedLoginDescription', {
  defaultMessage: 'attempted a login via'
});
const DISCONNECTED_VIA = exports.DISCONNECTED_VIA = _i18n.i18n.translate('xpack.securitySolution.system.disconnectedViaDescription', {
  defaultMessage: 'disconnected via'
});
const LOGGED_OUT = exports.LOGGED_OUT = _i18n.i18n.translate('xpack.securitySolution.system.loggedOutDescription', {
  defaultMessage: 'logged out via'
});
const USING = exports.USING = _i18n.i18n.translate('xpack.securitySolution.system.usingDescription', {
  defaultMessage: 'using'
});
const PROCESS_STARTED = exports.PROCESS_STARTED = _i18n.i18n.translate('xpack.securitySolution.system.processStartedDescription', {
  defaultMessage: 'started process'
});
const PROCESS_STOPPED = exports.PROCESS_STOPPED = _i18n.i18n.translate('xpack.securitySolution.system.processStoppedDescription', {
  defaultMessage: 'stopped process'
});
const TERMINATED_PROCESS = exports.TERMINATED_PROCESS = _i18n.i18n.translate('xpack.securitySolution.system.terminatedProcessDescription', {
  defaultMessage: 'terminated process'
});
const CREATED_FILE = exports.CREATED_FILE = _i18n.i18n.translate('xpack.securitySolution.system.createdFileDescription', {
  defaultMessage: 'created a file'
});
const DELETED_FILE = exports.DELETED_FILE = _i18n.i18n.translate('xpack.securitySolution.system.deletedFileDescription', {
  defaultMessage: 'deleted a file'
});
const EXECUTED_PROCESS = exports.EXECUTED_PROCESS = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.executedProcessDescription', {
  defaultMessage: 'executed process'
});
const FORKED_PROCESS = exports.FORKED_PROCESS = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.forkedProcessDescription', {
  defaultMessage: 'forked process'
});
const LOADED_LIBRARY = exports.LOADED_LIBRARY = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.loadedLibraryDescription', {
  defaultMessage: 'loaded library'
});
const MADE_A_HTTP_REQUEST_VIA = exports.MADE_A_HTTP_REQUEST_VIA = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.madeAHttpRequestViaDescription', {
  defaultMessage: 'made a http request via'
});
const MODIFIED_FILE = exports.MODIFIED_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.modifiedFileDescription', {
  defaultMessage: 'modified a file'
});
const MODIFIED_REGISTRY_KEY = exports.MODIFIED_REGISTRY_KEY = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.modifiedRegistryKeyDescription', {
  defaultMessage: 'modified registry key'
});
const OVERWROTE_FILE = exports.OVERWROTE_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.overwroteFileDescription', {
  defaultMessage: 'overwrote a file'
});
const RENAMED_FILE = exports.RENAMED_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.renamedFileDescription', {
  defaultMessage: 'renamed a file'
});
const EXISTING_PROCESS = exports.EXISTING_PROCESS = _i18n.i18n.translate('xpack.securitySolution.system.existingProcessDescription', {
  defaultMessage: 'is running process'
});
const SOCKET_OPENED = exports.SOCKET_OPENED = _i18n.i18n.translate('xpack.securitySolution.system.socketOpenedDescription', {
  defaultMessage: 'opened a socket with'
});
const SOCKET_CLOSED = exports.SOCKET_CLOSED = _i18n.i18n.translate('xpack.securitySolution.system.socketClosedDescription', {
  defaultMessage: 'closed a socket with'
});
const EXISTING_USER = exports.EXISTING_USER = _i18n.i18n.translate('xpack.securitySolution.system.existingUserDescription', {
  defaultMessage: 'is an existing user'
});
const EXISTING_SOCKET = exports.EXISTING_SOCKET = _i18n.i18n.translate('xpack.securitySolution.system.existingSocketDescription', {
  defaultMessage: 'is using an existing socket from'
});
const EXISTING_PACKAGE = exports.EXISTING_PACKAGE = _i18n.i18n.translate('xpack.securitySolution.system.existingPackageDescription', {
  defaultMessage: 'is using an existing package'
});
const INVALID = exports.INVALID = _i18n.i18n.translate('xpack.securitySolution.system.invalidDescription', {
  defaultMessage: 'attempted invalid usage of'
});
const USER_CHANGED = exports.USER_CHANGED = _i18n.i18n.translate('xpack.securitySolution.system.userChangedDescription', {
  defaultMessage: 'user has changed'
});
const HOST_CHANGED = exports.HOST_CHANGED = _i18n.i18n.translate('xpack.securitySolution.system.hostDescription', {
  defaultMessage: 'host information'
});
const USER_ADDED = exports.USER_ADDED = _i18n.i18n.translate('xpack.securitySolution.system.userAddedDescription', {
  defaultMessage: 'user was added'
});
const PROCESS_ERROR = exports.PROCESS_ERROR = _i18n.i18n.translate('xpack.securitySolution.system.processErrorDescription', {
  defaultMessage: 'encountered a process error with'
});
const ERROR = exports.ERROR = _i18n.i18n.translate('xpack.securitySolution.system.errorDescription', {
  defaultMessage: 'encountered an error with'
});
const PACKAGE_INSTALLED = exports.PACKAGE_INSTALLED = _i18n.i18n.translate('xpack.securitySolution.system.packageInstalledDescription', {
  defaultMessage: 'installed package'
});
const BOOT = exports.BOOT = _i18n.i18n.translate('xpack.securitySolution.system.packageSystemStartedDescription', {
  defaultMessage: 'system started'
});
const ACCEPTED = exports.ACCEPTED = _i18n.i18n.translate('xpack.securitySolution.system.acceptedDescription', {
  defaultMessage: 'accepted the user via'
});
const PACKAGE_UPDATED = exports.PACKAGE_UPDATED = _i18n.i18n.translate('xpack.securitySolution.system.packageUpdatedDescription', {
  defaultMessage: 'updated package'
});
const PACKAGE_REMOVED = exports.PACKAGE_REMOVED = _i18n.i18n.translate('xpack.securitySolution.system.packageRemovedDescription', {
  defaultMessage: 'removed package'
});
const USER_REMOVED = exports.USER_REMOVED = _i18n.i18n.translate('xpack.securitySolution.system.userRemovedDescription', {
  defaultMessage: 'was removed'
});
const VIA = exports.VIA = _i18n.i18n.translate('xpack.securitySolution.system.viaDescription', {
  defaultMessage: 'via'
});
const VIA_PARENT_PROCESS = exports.VIA_PARENT_PROCESS = _i18n.i18n.translate('xpack.securitySolution.system.viaParentProcessDescription', {
  defaultMessage: 'via parent process'
});
const RANSOMWARE_WAS_PREVENTED_FROM_ENCRYPTING_FILES = exports.RANSOMWARE_WAS_PREVENTED_FROM_ENCRYPTING_FILES = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.ransomwareWasPreventedFromeEcryptingFilesDescription', {
  defaultMessage: 'ransomware was prevented from encrypting files'
});
const RANSOMWARE_WAS_DETECTED_ENCRYPTING_FILES = exports.RANSOMWARE_WAS_DETECTED_ENCRYPTING_FILES = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.ransomwareWasDetectedEcryptingFilesDescription', {
  defaultMessage: 'ransomware was detected encrypting files'
});
const WAS_DETECTED_CREATING_A_MALICIOUS_FILE = exports.WAS_DETECTED_CREATING_A_MALICIOUS_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.wasDetectedCreatingAMaliciousFileDescription', {
  defaultMessage: 'was detected creating a malicious file'
});
const WAS_PREVENTED_FROM_CREATING_A_MALICIOUS_FILE = exports.WAS_PREVENTED_FROM_CREATING_A_MALICIOUS_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.wasPreventedFromCreatingAMaliciousFileDescription', {
  defaultMessage: 'was prevented from creating a malicious file'
});
const WAS_DETECTED_MODIFYING_A_MALICIOUS_FILE = exports.WAS_DETECTED_MODIFYING_A_MALICIOUS_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.wasDetectedModifyingAMaliciousFileDescription', {
  defaultMessage: 'was detected modifying a malicious file'
});
const WAS_PREVENTED_FROM_MODIFYING_A_MALICIOUS_FILE = exports.WAS_PREVENTED_FROM_MODIFYING_A_MALICIOUS_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.wasPreventedFromModifyingAMaliciousFileDescription', {
  defaultMessage: 'was prevented from modifying a malicious file'
});
const WAS_DETECTED_RENAMING_A_MALICIOUS_FILE = exports.WAS_DETECTED_RENAMING_A_MALICIOUS_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.wasDetectedRenamingAMaliciousFileDescription', {
  defaultMessage: 'was detected renaming a malicious file'
});
const WAS_PREVENTED_FROM_RENAMING_A_MALICIOUS_FILE = exports.WAS_PREVENTED_FROM_RENAMING_A_MALICIOUS_FILE = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.wasPreventedFromRenamingAMaliciousFileDescription', {
  defaultMessage: 'was prevented from renaming a malicious file'
});
const WAS_DETECTED_EXECUTING_A_MALICIOUS_PROCESS = exports.WAS_DETECTED_EXECUTING_A_MALICIOUS_PROCESS = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.wasDetectedExecutingAMaliciousProcessDescription', {
  defaultMessage: 'was detected executing a malicious process'
});
const WAS_PREVENTED_FROM_EXECUTING_A_MALICIOUS_PROCESS = exports.WAS_PREVENTED_FROM_EXECUTING_A_MALICIOUS_PROCESS = _i18n.i18n.translate('xpack.securitySolution.rowRenderer.wasPreventedFromExecutingAMaliciousProcessDescription', {
  defaultMessage: 'was prevented from executing a malicious process'
});
const WITH_EXIT_CODE = exports.WITH_EXIT_CODE = _i18n.i18n.translate('xpack.securitySolution.system.withExitCodeDescription', {
  defaultMessage: 'with exit code'
});