"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderUrl = exports.renderEventModule = exports.RenderRuleName = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _empty_value = require("../../../../../common/components/empty_value");
var _redirect_to_detection_engine = require("../../../../../common/components/link_to/redirect_to_detection_engine");
var _truncatable_text = require("../../../../../common/components/truncatable_text");
var _validators = require("../../../../../common/utils/validators");
var _color = _interopRequireDefault(require("../../../../../common/utils/logo_endpoint/64_color.svg"));
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../../../../app/types");
var _link_to = require("../../../../../common/components/link_to");
var _kibana = require("../../../../../common/lib/kibana");
var _constants = require("../../../../../../common/constants");
var _links = require("../../../../../common/components/links");
var _helpers = require("../../../../../common/components/links/helpers");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _right = require("../../../../../flyout/rule_details/right");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventModuleFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 100%;
`;
const RenderRuleName = ({
  children,
  Component,
  fieldName,
  isButton,
  onClick,
  linkValue,
  openInNewTab = false,
  truncate,
  title,
  value
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const ruleName = `${value}`;
  const ruleId = linkValue;
  const {
    search
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.rules);
  const {
    navigateToApp,
    getUrlForApp
  } = (0, _kibana.useKibana)().services.application;
  const isInTimelineContext = ruleName && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.enableHostDetailsFlyout) && (eventContext === null || eventContext === void 0 ? void 0 : eventContext.timelineID);
  const goToRuleDetails = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    if (!eventContext || !isInTimelineContext) {
      navigateToApp(_constants.APP_UI_ID, {
        deepLinkId: _types.SecurityPageName.rules,
        path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '', search),
        openInNewTab
      });
      return;
    }
    openFlyout({
      right: {
        id: _right.RulePanelKey,
        params: {
          ruleId
        }
      }
    });
  }, [navigateToApp, ruleId, search, openInNewTab, openFlyout, eventContext, isInTimelineContext]);
  const href = (0, _react.useMemo)(() => getUrlForApp(_constants.APP_UI_ID, {
    deepLinkId: _types.SecurityPageName.rules,
    path: (0, _redirect_to_detection_engine.getRuleDetailsUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '', search)
  }), [getUrlForApp, ruleId, search]);
  const link = (0, _react.useMemo)(() => {
    const content = truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
      dataTestSubj: `formatted-field-${fieldName}`
    }, value) : value;
    if (isButton) {
      return /*#__PURE__*/_react.default.createElement(_helpers.GenericLinkButton, {
        Component: Component,
        dataTestSubj: "data-grid-host-details",
        href: href,
        iconType: "expand",
        onClick: onClick !== null && onClick !== void 0 ? onClick : goToRuleDetails,
        title: title !== null && title !== void 0 ? title : ruleName
      }, children);
    } else if (Component) {
      return /*#__PURE__*/_react.default.createElement(Component, {
        "aria-label": title,
        "data-test-subj": `view-${fieldName}`,
        iconType: "link",
        onClick: goToRuleDetails,
        title: title
      }, title !== null && title !== void 0 ? title : value);
    } else if (openInNewTab) {
      return /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
        onClick: goToRuleDetails,
        href: href,
        "data-test-subj": "goToRuleDetails",
        target: "_blank",
        external: false
      }, children !== null && children !== void 0 ? children : content);
    } else {
      return /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
        onClick: goToRuleDetails,
        href: href,
        "data-test-subj": "ruleName"
      }, children !== null && children !== void 0 ? children : content);
    }
  }, [Component, children, fieldName, goToRuleDetails, href, isButton, onClick, ruleName, title, truncate, value, openInNewTab]);
  if ((0, _fp.isString)(value) && ruleName.length > 0 && ruleId != null) {
    return link;
  } else if (value != null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
  }
  return (0, _empty_value.getEmptyTagValue)();
};
exports.RenderRuleName = RenderRuleName;
const canYouAddEndpointLogo = (moduleName, endpointUrl) => moduleName.trim().toLocaleLowerCase() === 'endgame' && endpointUrl != null && !(0, _fp.isEmpty)(endpointUrl) && !(0, _validators.isUrlInvalid)(endpointUrl) && endpointUrl.includes('/alerts/');
const renderEventModule = ({
  linkValue,
  truncate,
  value
}) => {
  const moduleName = `${value}`;
  const endpointRefUrl = linkValue;
  const content = truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, null, value) : value;
  return (0, _fp.isString)(value) && moduleName.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: endpointRefUrl != null && !(0, _fp.isEmpty)(endpointRefUrl) ? 'flexStart' : 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(EventModuleFlexItem, null, content), endpointRefUrl != null && canYouAddEndpointLogo(moduleName, endpointRefUrl) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "event-module-link-to-elastic-endpoint-security",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, i18n.LINK_ELASTIC_ENDPOINT_SECURITY), /*#__PURE__*/_react.default.createElement("p", null, endpointRefUrl))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: endpointRefUrl,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _color.default,
    size: "m"
  }))))) : (0, _empty_value.getEmptyTagValue)();
};
exports.renderEventModule = renderEventModule;
const GenericLinkComponent = ({
  children,
  Component,
  dataTestSubj,
  href,
  onClick,
  title,
  iconType = 'link'
}) => {
  return Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": dataTestSubj,
    href: href,
    iconType: iconType,
    onClick: onClick,
    title: title
  }, title !== null && title !== void 0 ? title : children) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": dataTestSubj,
    target: "_blank",
    href: href
  }, title !== null && title !== void 0 ? title : children);
};
const GenericLink = /*#__PURE__*/_react.default.memo(GenericLinkComponent);
const renderUrl = ({
  Component,
  truncate,
  title,
  value
}) => {
  const urlName = `${value}`;
  const isUrlValid = !(0, _validators.isUrlInvalid)(urlName);
  const formattedValue = truncate ? /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, null, value) : value;
  const content = isUrlValid ? /*#__PURE__*/_react.default.createElement(GenericLink, {
    Component: Component,
    href: urlName,
    dataTestSubj: "ata-grid-url",
    title: title,
    iconType: "link"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, formattedValue);
  return (0, _fp.isString)(value) && urlName.length > 0 ? content : (0, _empty_value.getEmptyTagValue)();
};
exports.renderUrl = renderUrl;