"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emptyColumnRenderer = exports.dataNotExistsAtColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _empty_value = require("../../../../../common/components/empty_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataNotExistsAtColumn = (columnName, data) => data.findIndex(item => item.field === columnName) === -1;
exports.dataNotExistsAtColumn = dataNotExistsAtColumn;
const emptyColumnRenderer = exports.emptyColumnRenderer = {
  isInstance: (columnName, data) => dataNotExistsAtColumn(columnName, data),
  renderColumn: () => /*#__PURE__*/_react.default.createElement("span", null, (0, _empty_value.getEmptyValue)())
};