"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStatefulRowRenderer = useStatefulRowRenderer;
var _react = require("react");
var _get_row_renderer = require("../../renderers/get_row_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStatefulRowRenderer(args) {
  const {
    data,
    rowRenderers
  } = args;
  const rowRenderer = (0, _react.useMemo)(() => (0, _get_row_renderer.getRowRenderer)({
    data,
    rowRenderers
  }), [data, rowRenderers]);
  const result = (0, _react.useMemo)(() => ({
    canShowRowRenderer: rowRenderer != null,
    rowRenderer
  }), [rowRenderer]);
  return result;
}