"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemSocketExample = void 0;
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../timeline/body/renderers/system/translations");
var _generic_row_renderer = require("../../timeline/body/renderers/system/generic_row_renderer");
var _ipv = require("../../../../common/demo_data/endgame_ecs/ipv4");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SystemSocketExampleComponent = () => {
  const systemSocketRowRenderer = (0, _generic_row_renderer.createSocketRowRenderer)({
    actionName: 'ipv4_connection_accept_event',
    text: _translations.ACCEPTED_A_CONNECTION_VIA
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, systemSocketRowRenderer.renderRow({
    data: _ipv.demoEndgameIpv4ConnectionAcceptEvent,
    scopeId: _constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID
  }));
};
const SystemSocketExample = exports.SystemSocketExample = /*#__PURE__*/_react.default.memo(SystemSocketExampleComponent);