"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteTimelineModal = exports.DELETE_TIMELINE_MODAL_WIDTH = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _reactRouterDom = require("react-router-dom");
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/api/timeline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_TIMELINE_MODAL_WIDTH = exports.DELETE_TIMELINE_MODAL_WIDTH = 600; // px

/**
 * Renders a modal that confirms deletion of a timeline
 */
const DeleteTimelineModal = exports.DeleteTimelineModal = /*#__PURE__*/_react.default.memo(({
  title,
  closeModal,
  onDelete
}) => {
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const warning = tabName === _timeline.TimelineTypeEnum.template ? i18n.DELETE_TIMELINE_TEMPLATE_WARNING : i18n.DELETE_TIMELINE_WARNING;
  const getTitle = (0, _react.useCallback)(() => {
    const trimmedTitle = title != null ? title.trim() : '';
    const titleResult = !(0, _fp.isEmpty)(trimmedTitle) ? trimmedTitle : i18n.UNTITLED_TIMELINE;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.open.timeline.deleteTimelineModalTitle",
      defaultMessage: "Delete \"{title}\"?",
      "data-test-subj": "title",
      values: {
        title: titleResult
      }
    });
  }, [title]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    cancelButtonText: i18n.CANCEL,
    confirmButtonText: i18n.DELETE,
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    onCancel: closeModal,
    onConfirm: onDelete,
    title: getTitle()
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "warning"
  }, warning));
});
DeleteTimelineModal.displayName = 'DeleteTimelineModal';