"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAndAssociateNode = exports.search = exports.createNote = exports.NotesCount = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _uuid = require("uuid");
var i18n = _interopRequireWildcard(require("./translations"));
var _page = require("../../../common/components/page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Performs IO to update (or add a new) note */

/** Performs IO to associate a note with something (e.g. a timeline, an event, etc). (The "something" is opaque to the caller) */

/** Updates the local state containing a new note being edited by the user */

/**
 * Defines the behavior of the search input that appears above the table of data
 */
const search = exports.search = {
  box: {
    incremental: true,
    placeholder: i18n.SEARCH_PLACEHOLDER,
    schema: {
      fields: {
        user: 'string',
        note: 'string'
      }
    }
  }
};
const TitleText = _styledComponents.default.h3`
  margin: 0 5px;
  cursor: default;
  user-select: none;
`;
TitleText.displayName = 'TitleText';

/** Displays a count of the existing notes */
const NotesCount = exports.NotesCount = /*#__PURE__*/_react.default.memo(({
  noteIds
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  color: "text",
  size: "l",
  type: "editorComment"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(TitleText, null, i18n.NOTES))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_page.CountBadge, {
  color: "hollow"
}, noteIds.length))));
NotesCount.displayName = 'NotesCount';

/** Creates a new instance of a `note` */
const createNote = ({
  newNote,
  user
}) => ({
  created: _moment.default.utc().toDate(),
  id: (0, _uuid.v4)(),
  lastEdit: null,
  note: newNote,
  saveObjectId: null,
  user,
  version: null
});
exports.createNote = createNote;
const updateAndAssociateNode = ({
  associateNote,
  newNote,
  updateNewNote,
  updateNote,
  user
}) => {
  const note = createNote({
    newNote,
    user
  });
  updateNote(note); // perform IO to store the newly-created note
  associateNote(note.id); // associate the note with the (opaque) thing
  updateNewNote(''); // clear the input
};
exports.updateAndAssociateNode = updateAndAssociateNode;