"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAVED_TIMELINE_WARNING = exports.TITLE = exports.TIMELINE_TITLE = exports.TIMELINE_DESCRIPTION = exports.SAVE_TIMELINE_TEMPLATE = exports.SAVE_TIMELINE = exports.SAVE_AS_NEW = exports.SAVE = exports.OPTIONAL = exports.OPEN_TIMELINE_BTN_LABEL = exports.OPEN_TIMELINE_BTN = exports.NEW_TIMELINE_BTN = exports.NEW_TIMELINE = exports.NEW_TEMPLATE_TIMELINE = exports.NAME_TIMELINE_TEMPLATE = exports.DISCARD_TIMELINE_TEMPLATE = exports.DISCARD_TIMELINE = exports.CLOSE_MODAL = exports.CALL_OUT_UNAUTHORIZED_MSG = exports.ATTACH_TO_NEW_CASE = exports.ATTACH_TO_EXISTING_CASE = exports.ATTACH_TO_CASE = void 0;
var _i18n = require("@kbn/i18n");
var _timeline = require("../../../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_TIMELINE_BTN = exports.NEW_TIMELINE_BTN = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.newTimelineBtn', {
  defaultMessage: 'New'
});
const NEW_TIMELINE = exports.NEW_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.newTimeline', {
  defaultMessage: 'New Timeline'
});
const NEW_TEMPLATE_TIMELINE = exports.NEW_TEMPLATE_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.newTimelineTemplate', {
  defaultMessage: 'New Timeline template'
});
const OPEN_TIMELINE_BTN = exports.OPEN_TIMELINE_BTN = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.openTimelineBtn', {
  defaultMessage: 'Open'
});
const OPEN_TIMELINE_BTN_LABEL = exports.OPEN_TIMELINE_BTN_LABEL = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.openTimelineBtnLabel', {
  defaultMessage: 'Open Existing Timeline'
});
const ATTACH_TO_CASE = exports.ATTACH_TO_CASE = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.attachToCaseButtonLabel', {
  defaultMessage: 'Attach to case'
});
const ATTACH_TO_NEW_CASE = exports.ATTACH_TO_NEW_CASE = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.attachToNewCaseButtonLabel', {
  defaultMessage: 'Attach to new case'
});
const ATTACH_TO_EXISTING_CASE = exports.ATTACH_TO_EXISTING_CASE = _i18n.i18n.translate('xpack.securitySolution.timeline.modal.attachToExistingCaseButtonLabel', {
  defaultMessage: 'Attach to existing case'
});
const CALL_OUT_UNAUTHORIZED_MSG = exports.CALL_OUT_UNAUTHORIZED_MSG = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.unauthorized.message.description', {
  defaultMessage: 'You can use Timeline to investigate events, but you do not have the required permissions to save timelines for future use. If you need to save timelines, contact your Kibana administrator.'
});
const SAVE_TIMELINE = exports.SAVE_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.header', {
  defaultMessage: 'Save Timeline'
});
const SAVE_TIMELINE_TEMPLATE = exports.SAVE_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimelineTemplate.modal.header', {
  defaultMessage: 'Save Timeline Template'
});
const SAVE = exports.SAVE = _i18n.i18n.translate('xpack.securitySolution.timeline.nameTimeline.save.title', {
  defaultMessage: 'Save'
});
const NAME_TIMELINE_TEMPLATE = exports.NAME_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.nameTimelineTemplate.modal.header', {
  defaultMessage: 'Name Timeline Template'
});
const DISCARD_TIMELINE = exports.DISCARD_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.discard.title', {
  defaultMessage: 'Discard Timeline'
});
const DISCARD_TIMELINE_TEMPLATE = exports.DISCARD_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimelineTemplate.modal.discard.title', {
  defaultMessage: 'Discard Timeline Template'
});
const CLOSE_MODAL = exports.CLOSE_MODAL = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.close.title', {
  defaultMessage: 'Close'
});
const UNSAVED_TIMELINE_WARNING = timelineType => _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.warning.title', {
  values: {
    timeline: timelineType === _timeline.TimelineTypeEnum.template ? 'timeline template' : 'timeline'
  },
  defaultMessage: 'You have an unsaved {timeline}. Do you wish to save it?'
});
exports.UNSAVED_TIMELINE_WARNING = UNSAVED_TIMELINE_WARNING;
const TIMELINE_TITLE = exports.TIMELINE_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.titleAriaLabel', {
  defaultMessage: 'Title'
});
const TIMELINE_DESCRIPTION = exports.TIMELINE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.descriptionLabel', {
  defaultMessage: 'Description'
});
const OPTIONAL = exports.OPTIONAL = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.optionalLabel', {
  defaultMessage: 'Optional'
});
const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.title', {
  defaultMessage: 'Title'
});
const SAVE_AS_NEW = exports.SAVE_AS_NEW = _i18n.i18n.translate('xpack.securitySolution.timeline.saveTimeline.modal.saveAsNew', {
  defaultMessage: 'Save as new timeline'
});