"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigateInTimeline = void 0;
var _react = require("react");
var _defaults = require("../timelines/store/defaults");
var _constants = require("../../common/constants");
var _timeline = require("../../common/types/timeline");
var _timeline2 = require("../../common/api/timeline");
var _use_start_transaction = require("../common/lib/apm/use_start_transaction");
var _use_create_timeline = require("../timelines/hooks/use_create_timeline");
var _use_update_timeline = require("../timelines/components/open_timeline/use_update_timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook passed down to the Threat Intelligence plugin, via context.
 * This code is closely duplicated from here: https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/timeline_actions/use_investigate_in_timeline.tsx,
 * the main changes being:
 * - no exceptions are handled at the moment
 * - we use dataProviders, from and to directly instead of consuming ecsData
 */
const useInvestigateInTimeline = ({
  dataProviders,
  from,
  to
}) => {
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const clearActiveTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _timeline2.TimelineTypeEnum.default
  });
  const updateTimeline = (0, _use_update_timeline.useUpdateTimeline)();
  const createTimeline = (0, _react.useCallback)(async ({
    from: fromTimeline,
    timeline,
    to: toTimeline,
    ruleNote
  }) => {
    var _timeline$indexNames;
    await clearActiveTimeline();
    updateTimeline({
      duplicate: true,
      from: fromTimeline,
      id: _timeline.TimelineId.active,
      notes: [],
      timeline: {
        ...timeline,
        indexNames: (_timeline$indexNames = timeline.indexNames) !== null && _timeline$indexNames !== void 0 ? _timeline$indexNames : [],
        show: true
      },
      to: toTimeline,
      ruleNote
    });
  }, [updateTimeline, clearActiveTimeline]);
  const investigateInTimelineClick = (0, _react.useCallback)(async () => {
    startTransaction({
      name: `${_constants.APP_UI_ID} threat indicator investigateInTimeline`
    });
    createTimeline({
      from,
      notes: null,
      timeline: {
        ..._defaults.timelineDefaults,
        dataProviders,
        id: _timeline.TimelineId.active,
        indexNames: [],
        dateRange: {
          start: from,
          end: to
        },
        eventType: 'all',
        filters: [],
        kqlQuery: {
          filterQuery: {
            kuery: {
              kind: 'kuery',
              expression: ''
            },
            serializedQuery: ''
          }
        }
      },
      to,
      ruleNote: ''
    });
  }, [startTransaction, createTimeline, dataProviders, from, to]);
  return investigateInTimelineClick;
};
exports.useInvestigateInTimeline = useInvestigateInTimeline;