"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indicatorsLinks = void 0;
var _public = require("@kbn/threat-intelligence-plugin/public");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Adds the Threat Intelligence entry to Kibana global sidenav as well as the Security sidenav.
 * Most of the properties are coming from the Threat Intelligence plugin directly through {@link getSecuritySolutionLink}.
 * The ones added below are more related to the Security Solution plugin.
 */
const indicatorsLinks = exports.indicatorsLinks = {
  ...(0, _public.getSecuritySolutionLink)('indicators'),
  globalNavPosition: 8,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.threat-intelligence`]
};