"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSourcererDataView = void 0;
var _sourcerer = require("../../../common/utils/sourcerer");
var _use_data_view = require("../../common/containers/source/use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSourcererDataView = async (dataViewId, dataViewsService, refreshFields = false) => {
  var _dataViewData$id, _dataViewData$id2;
  const dataView = await dataViewsService.get(dataViewId, true, refreshFields);
  const dataViewData = dataView.toSpec();
  const defaultPatternsList = (0, _sourcerer.ensurePatternFormat)(dataView.getIndexPattern().split(','));
  const patternList = await dataViewsService.getExistingIndices(defaultPatternsList);
  return {
    loading: false,
    id: (_dataViewData$id = dataViewData.id) !== null && _dataViewData$id !== void 0 ? _dataViewData$id : '',
    title: dataView.getIndexPattern(),
    fields: dataViewData.fields,
    patternList,
    dataView: dataViewData,
    browserFields: (0, _use_data_view.getDataViewStateFromIndexFields)((_dataViewData$id2 = dataViewData.id) !== null && _dataViewData$id2 !== void 0 ? _dataViewData$id2 : '', dataViewData.fields).browserFields
  };
};
exports.getSourcererDataView = getSourcererDataView;