"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateMigration = exports.RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_TITLE = exports.RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION = exports.RULES_DATA_INPUT_CREATE_MIGRATION_ERROR = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _api_request_reducer = require("./common/api_request_reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_TITLE = exports.RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.service.createRuleSuccess.title', {
  defaultMessage: 'Rule migration created successfully'
});
const RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION = rules => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.service.createRuleSuccess.description', {
  defaultMessage: '{rules} rules uploaded',
  values: {
    rules
  }
});
exports.RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION = RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION;
const RULES_DATA_INPUT_CREATE_MIGRATION_ERROR = exports.RULES_DATA_INPUT_CREATE_MIGRATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.service.createRuleError', {
  defaultMessage: 'Failed to upload rules file'
});
const useCreateMigration = onSuccess => {
  const {
    siemMigrations,
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const [state, dispatch] = (0, _react.useReducer)(_api_request_reducer.reducer, _api_request_reducer.initialState);
  const createMigration = (0, _react.useCallback)((migrationName, rules) => {
    (async () => {
      try {
        dispatch({
          type: 'start'
        });
        const migrationId = await siemMigrations.rules.createRuleMigration(rules, migrationName);
        const stats = await siemMigrations.rules.api.getRuleMigrationStats({
          migrationId
        });
        notifications.toasts.addSuccess({
          title: RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_TITLE,
          text: RULES_DATA_INPUT_CREATE_MIGRATION_SUCCESS_DESCRIPTION(rules.length)
        });
        onSuccess(stats);
        dispatch({
          type: 'success'
        });
      } catch (err) {
        var _err$body;
        const apiError = (_err$body = err.body) !== null && _err$body !== void 0 ? _err$body : err;
        notifications.toasts.addError(apiError, {
          title: RULES_DATA_INPUT_CREATE_MIGRATION_ERROR
        });
        dispatch({
          type: 'error',
          error: apiError
        });
      }
    })();
  }, [siemMigrations.rules, notifications.toasts, onSuccess]);
  return {
    isLoading: state.loading,
    error: state.error,
    createMigration
  };
};
exports.useCreateMigration = useCreateMigration;