"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemMigrationSetupTour = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tourConfig = {
  currentTourStep: 1,
  isTourActive: true,
  tourPopoverWidth: 360
};
const SiemMigrationSetupTour = exports.SiemMigrationSetupTour = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const {
    siemMigrations,
    storage
  } = (0, _kibana.useKibana)().services;
  const [tourState, setTourState] = (0, _react.useState)(() => {
    const restoredTourState = storage.get(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.SIEM_MAIN_LANDING_PAGE);
    if (restoredTourState != null) {
      return restoredTourState;
    }
    return tourConfig;
  });
  const onTourFinished = (0, _react.useCallback)(() => {
    setTourState({
      ...tourState,
      isTourActive: false
    });
  }, [tourState]);
  (0, _react.useEffect)(() => {
    storage.set(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.SIEM_MAIN_LANDING_PAGE, tourState);
  }, [tourState, storage]);
  const [tourDelayElapsed, setTourDelayElapsed] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    // visible EuiTourStep anchors don't follow the button when the layout changes
    const timeout = setTimeout(() => setTourDelayElapsed(true), 1000);
    return () => clearTimeout(timeout);
  }, []);
  const showTour = (0, _react.useMemo)(() => {
    return siemMigrations.rules.isAvailable() && tourState.isTourActive && tourDelayElapsed;
  }, [siemMigrations.rules, tourDelayElapsed, tourState.isTourActive]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    anchorPosition: "downCenter",
    content: i18n.SETUP_SIEM_MIGRATION_TOUR_CONTENT,
    isStepOpen: showTour,
    maxWidth: tourState.tourPopoverWidth,
    onFinish: onTourFinished,
    step: 1,
    stepsTotal: 1,
    subtitle: i18n.SETUP_SIEM_MIGRATION_TOUR_SUBTITLE,
    title: i18n.SETUP_SIEM_MIGRATION_TOUR_TITLE,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      color: "text",
      flush: "right",
      onClick: onTourFinished
    }, i18n.FINISH_TOUR_BUTTON)
  }, children);
});
SiemMigrationSetupTour.displayName = 'SiemMigrationSetupTour';