"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartRuleMigrationModal = exports.DATA_TEST_SUBJ_PREFIX = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _securitySolutionConnectors = require("@kbn/security-solution-connectors");
var _use_ai_connectors = require("../../../../../common/hooks/use_ai_connectors");
var _kibana = require("../../../../../common/lib/kibana");
var _constants = require("../../../../../onboarding/constants");
var _links = require("../../../../../common/components/links");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_TEST_SUBJ_PREFIX = exports.DATA_TEST_SUBJ_PREFIX = 'startMigrationModal';
const StartRuleMigrationModal = exports.StartRuleMigrationModal = /*#__PURE__*/_react.default.memo(function StartRuleMigrationModal({
  defaultSettings = {},
  onClose: closeModal,
  onStartMigrationWithSettings: startMigrationWithSettings,
  numberOfRules = 0
}) {
  var _aiConnectors$;
  const {
    connectorId,
    skipPrebuiltRulesMatching
  } = defaultSettings;
  const {
    siemMigrations,
    settings
  } = (0, _kibana.useKibana)().services;
  const {
    aiConnectors,
    isLoading
  } = (0, _use_ai_connectors.useAIConnectors)();
  const [selectedConnectorId, setSelectedConnectorId] = (0, _react.useState)(connectorId || siemMigrations.rules.connectorIdStorage.get() || ((_aiConnectors$ = aiConnectors[0]) === null || _aiConnectors$ === void 0 ? void 0 : _aiConnectors$.id));
  const [enablePrebuiltRulesMatching, setEnablePrebuiltRuleMatching] = (0, _react.useState)(!skipPrebuiltRulesMatching);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const {
    onClick: onClickSetupAIConnector,
    href: setupAIConnectorLink
  } = getSecuritySolutionLinkProps({
    deepLinkId: _deeplinksSecurity.SecurityPageName.landing,
    path: `${_constants.OnboardingTopicId.siemMigrations}#${_constants.OnboardingCardId.siemMigrationsAiConnectors}`
  });
  const onStartMigrationWithSettings = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (!selectedConnectorId) {
      return;
    }
    startMigrationWithSettings({
      connectorId: selectedConnectorId,
      skipPrebuiltRulesMatching: !enablePrebuiltRulesMatching
    });
    closeModal();
  }, [startMigrationWithSettings, selectedConnectorId, enablePrebuiltRulesMatching, closeModal]);
  const errors = (0, _react.useMemo)(() => {
    const allErrors = [];
    if (!selectedConnectorId) {
      allErrors.push(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.startMigrationModal.connectorRequiredError",
        defaultMessage: "An AI connector is required to start the translation."
      }));
    }
    return allErrors;
  }, [selectedConnectorId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "data-test-subj": DATA_TEST_SUBJ_PREFIX
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Title`,
    id: modalTitleId
  }, i18n.REPROCESS_RULES_DIALOG_TITLE(numberOfRules))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, i18n.REPROCESS_RULES_DIALOG_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: onStartMigrationWithSettings,
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Form`,
    isInvalid: !selectedConnectorId,
    error: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.START_RULE_MIGRATION_MODAL_AI_CONNECTOR_LABEL,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.siemMigrations.reprocessFailedRulesDialog.connectorHelpText",
      defaultMessage: 'To setup other LLM connectors, visit {link}.',
      values: {
        link:
        /*#__PURE__*/
        /* eslint-disable-next-line @elastic/eui/href-or-on-click */
        _react.default.createElement(_eui.EuiLink, {
          href: setupAIConnectorLink,
          onClick: onClickSetupAIConnector
        }, i18n.START_RULE_MIGRATION_MODAL_SETUP_NEW_AI_CONNECTOR_HELP_TEXT)
      }
    }),
    isInvalid: !selectedConnectorId,
    "aria-required": true
  }, /*#__PURE__*/_react.default.createElement(_securitySolutionConnectors.ConnectorSelector, {
    connectors: aiConnectors,
    selectedId: selectedConnectorId,
    onChange: setSelectedConnectorId,
    isInvalid: !selectedConnectorId,
    isLoading: isLoading,
    mode: 'combobox',
    settings: settings
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-PrebuiltRulesMatchingSwitch`,
    label: i18n.START_RULE_MIGRATION_MODAL_PREBUILT_RULES_LABEL,
    checked: enablePrebuiltRulesMatching,
    onChange: e => setEnablePrebuiltRuleMatching(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Cancel`
  }, i18n.START_RULE_MIGRATION_MODAL_CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Translate`,
    color: "primary",
    fill: true
  }, i18n.START_RULE_MIGRATION_MODAL_TRANSLATE)))))));
});