"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/siem_migrations/constants");
var _translation_results = require("../../../utils/translation_results");
var _types = require("../../../types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_FILTER_POPOVER_WIDTH = 250;
const StatusFilterButton = exports.StatusFilterButton = /*#__PURE__*/_react.default.memo(({
  status,
  onStatusChanged
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const selectableOptions = [{
    label: i18n.INSTALL_FILTER_OPTION,
    data: {
      status: _types.StatusFilter.INSTALLED
    },
    checked: status === _types.StatusFilter.INSTALLED ? 'on' : undefined
  }, {
    label: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.FULL),
    data: {
      status: _types.StatusFilter.TRANSLATED
    },
    checked: status === _types.StatusFilter.TRANSLATED ? 'on' : undefined
  }, {
    label: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.PARTIAL),
    data: {
      status: _types.StatusFilter.PARTIALLY_TRANSLATED
    },
    checked: status === _types.StatusFilter.PARTIALLY_TRANSLATED ? 'on' : undefined
  }, {
    label: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.UNTRANSLATABLE),
    data: {
      status: _types.StatusFilter.UNTRANSLATABLE
    },
    checked: status === _types.StatusFilter.UNTRANSLATABLE ? 'on' : undefined
  }, {
    label: i18n.FAILED_FILTER_OPTION,
    data: {
      status: _types.StatusFilter.FAILED
    },
    checked: status === _types.StatusFilter.FAILED ? 'on' : undefined
  }];
  const handleOptionsChange = (0, _react.useCallback)((_options, _event, changedOption) => {
    var _changedOption$data;
    setIsPopoverOpen(false);
    if (changedOption.checked && changedOption !== null && changedOption !== void 0 && (_changedOption$data = changedOption.data) !== null && _changedOption$data !== void 0 && _changedOption$data.status) {
      onStatusChanged(changedOption.data.status);
    } else if (!changedOption.checked) {
      onStatusChanged();
    }
  }, [onStatusChanged]);
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => {
      setIsPopoverOpen(!isPopoverOpen);
    },
    isSelected: isPopoverOpen,
    hasActiveFilters: status !== undefined,
    numActiveFilters: status ? 1 : 0,
    "data-test-subj": "statusFilterButton"
  }, i18n.STATUS_BUTTON_TITLE);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(!isPopoverOpen);
    },
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.STATUS_FILTER_ARIAL_LABEL,
    options: selectableOptions,
    onChange: handleOptionsChange,
    singleSelection: true,
    "data-test-subj": "statusFilterSelectableList"
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: STATUS_FILTER_POPOVER_WIDTH
    }
  }, list)));
});
StatusFilterButton.displayName = 'StatusFilterButton';