"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatedByLabel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _use_bulk_get_user_profiles = require("../../../../../common/components/user_profiles/use_bulk_get_user_profiles");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdatedByLabel = exports.UpdatedByLabel = /*#__PURE__*/_react.default.memo(({
  migrationRule
}) => {
  var _userProfile$user$ful, _migrationRule$update2;
  const userProfileId = (0, _react.useMemo)(() => {
    var _migrationRule$update;
    return new Set([(_migrationRule$update = migrationRule.updated_by) !== null && _migrationRule$update !== void 0 ? _migrationRule$update : migrationRule.created_by]);
  }, [migrationRule.created_by, migrationRule.updated_by]);
  const {
    isLoading: isLoadingUserProfiles,
    data: userProfiles
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: userProfileId
  });
  if (isLoadingUserProfiles || !(userProfiles !== null && userProfiles !== void 0 && userProfiles.length)) {
    return null;
  }
  const userProfile = userProfiles[0];
  const updatedBy = (_userProfile$user$ful = userProfile.user.full_name) !== null && _userProfile$user$ful !== void 0 ? _userProfile$user$ful : userProfile.user.username;
  const updatedAt = (_migrationRule$update2 = migrationRule.updated_at) !== null && _migrationRule$update2 !== void 0 ? _migrationRule$update2 : migrationRule['@timestamp'];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rules.translationDetails.updatedByLabel",
    defaultMessage: "{updated}: {by} on {date}",
    values: {
      updated: /*#__PURE__*/_react.default.createElement("b", null, i18n.LAST_UPDATED_LABEL),
      by: updatedBy,
      date: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        value: updatedAt,
        fieldName: "updated_at"
      })
    }
  }));
});
UpdatedByLabel.displayName = 'UpdatedByLabel';