"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationResultPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _chartsTheme = require("@kbn/charts-theme");
var _react2 = require("@emotion/react");
var _panel_text = require("../../../../common/components/panel_text");
var _translation_results = require("../../utils/translation_results");
var _use_get_migration_translation_stats = require("../../logic/use_get_migration_translation_stats");
var _centered_loading_spinner = require("../../../../common/components/centered_loading_spinner");
var _links = require("../../../../common/components/links");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _upload_missing_panel = require("./upload_missing_panel");
var _last_error = require("./last_error");
var _migration_panel_title = require("./migration_panel_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const headerStyle = (0, _react2.css)`
  &:hover {
    cursor: pointer;
    text-decoration: underline;
  }
`;
const useCompleteBadgeStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return (0, _react2.css)`
    background-color: ${isDarkMode ? euiTheme.colors.success : euiTheme.colors.backgroundBaseSuccess};
    color: ${isDarkMode ? euiTheme.colors.plainDark : euiTheme.colors.textSuccess};
    text-decoration: none;
  `;
};
const MigrationResultPanel = exports.MigrationResultPanel = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  isCollapsed = false,
  onToggleCollapsed
}) => {
  var _migrationStats$last_;
  const {
    data: translationStats,
    isLoading: isLoadingTranslationStats
  } = (0, _use_get_migration_translation_stats.useGetMigrationTranslationStats)(migrationStats.id);
  const completeBadgeStyles = useCompleteBadgeStyles();
  const toggleCollapsed = (0, _react.useCallback)(() => {
    onToggleCollapsed(!isCollapsed);
  }, [isCollapsed, onToggleCollapsed]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    onClick: toggleCollapsed,
    css: headerStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_migration_panel_title.MigrationPanelTitle, {
    migrationStats: migrationStats
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    subdued: true
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.RULE_MIGRATION_COMPLETE_DESCRIPTION((0, _moment.default)(migrationStats.created_at).format('MMMM Do YYYY, h:mm:ss a'), (0, _moment.default)(migrationStats.last_updated_at).fromNow())))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: completeBadgeStyles
  }, i18n.RULE_MIGRATION_COMPLETE_BADGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isCollapsed ? 'arrowDown' : 'arrowUp',
    onClick: toggleCollapsed,
    "aria-label": isCollapsed ? i18n.RULE_MIGRATION_EXPAND : i18n.RULE_MIGRATION_COLLAPSE
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: migrationStats.id,
    initialIsOpen: !isCollapsed,
    forceState: isCollapsed ? 'closed' : 'open',
    arrowDisplay: 'none'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "m"
  }, ((_migrationStats$last_ = migrationStats.last_execution) === null || _migrationStats$last_ === void 0 ? void 0 : _migrationStats$last_.error) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_last_error.RuleMigrationsLastError, {
    message: migrationStats.last_execution.error
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "stretch",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _aiAssistantIcon.AssistantIcon,
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    semiBold: true
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.RULE_MIGRATION_SUMMARY_TITLE))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "stretch",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoadingTranslationStats ? /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, null) : translationStats && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    css: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement("b", null, i18n.RULE_MIGRATION_SUMMARY_CHART_TITLE)), /*#__PURE__*/_react.default.createElement(TranslationResultsChart, {
    translationStats: translationStats
  }), /*#__PURE__*/_react.default.createElement(TranslationResultsTable, {
    translationStats: translationStats
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    deepLinkId: _securitySolutionNavigation.SecurityPageName.siemMigrationsRules,
    path: migrationStats.id
  }, i18n.RULE_MIGRATION_VIEW_TRANSLATED_RULES_BUTTON)))))))), /*#__PURE__*/_react.default.createElement(_upload_missing_panel.RuleMigrationsUploadMissingPanel, {
    migrationStats: migrationStats,
    topSpacerSize: "s"
  }))));
});
MigrationResultPanel.displayName = 'MigrationResultPanel';
const TranslationResultsChart = /*#__PURE__*/_react.default.memo(({
  translationStats
}) => {
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const translationResultColors = (0, _translation_results.useResultVisColors)();
  const data = [{
    category: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.FULL),
    value: translationStats.rules.success.result.full
  }, {
    category: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.PARTIAL),
    value: translationStats.rules.success.result.partial
  }, {
    category: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.UNTRANSLATABLE),
    value: translationStats.rules.success.result.untranslatable
  }, {
    category: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    type: i18n.RULE_MIGRATION_TRANSLATION_FAILED,
    value: translationStats.rules.failed
  }];
  const colors = [translationResultColors[_constants.RuleTranslationResult.FULL], translationResultColors[_constants.RuleTranslationResult.PARTIAL], translationResultColors[_constants.RuleTranslationResult.UNTRANSLATABLE], translationResultColors.error];
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 130
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    rotation: 90,
    baseTheme: baseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "results",
    name: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    data: data,
    xAccessor: "category",
    yAccessors: ['value'],
    splitSeriesAccessors: ['type'],
    stackAccessors: ['category'],
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    color: colors
  }));
});
TranslationResultsChart.displayName = 'TranslationResultsChart';
const columns = [{
  field: 'title',
  name: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
  render: (title, {
    color
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    textSize: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `translationStatus-${title}`
  }, title, " "))
}, {
  field: 'value',
  name: i18n.RULE_MIGRATION_TABLE_COLUMN_RULES,
  align: 'right',
  render: (value, {
    title
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": `translationStatusCount-${title}`
  }, value)
}];
const TranslationResultsTable = /*#__PURE__*/_react.default.memo(({
  translationStats
}) => {
  const translationResultColors = (0, _translation_results.useResultVisColors)();
  const items = (0, _react.useMemo)(() => [{
    title: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.FULL),
    value: translationStats.rules.success.result.full,
    color: translationResultColors[_constants.RuleTranslationResult.FULL]
  }, {
    title: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.PARTIAL),
    value: translationStats.rules.success.result.partial,
    color: translationResultColors[_constants.RuleTranslationResult.PARTIAL]
  }, {
    title: (0, _translation_results.convertTranslationResultIntoText)(_constants.RuleTranslationResult.UNTRANSLATABLE),
    value: translationStats.rules.success.result.untranslatable,
    color: translationResultColors[_constants.RuleTranslationResult.UNTRANSLATABLE]
  }, {
    title: i18n.RULE_MIGRATION_TRANSLATION_FAILED,
    value: translationStats.rules.failed,
    color: translationResultColors.error
  }], [translationStats, translationResultColors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "translatedResultsTable",
    items: items,
    columns: columns,
    compressed: true
  });
});
TranslationResultsTable.displayName = 'TranslationResultsTable';