"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationProgressPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _panel_text = require("../../../../common/components/panel_text");
var _use_stop_migration = require("../../service/hooks/use_stop_migration");
var i18n = _interopRequireWildcard(require("./translations"));
var _read_more = require("./read_more");
var _migration_panel_title = require("./migration_panel_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MigrationProgressPanel = exports.MigrationProgressPanel = /*#__PURE__*/_react.default.memo(({
  migrationStats
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    stopMigration,
    isLoading: isStopping
  } = (0, _use_stop_migration.useStopMigration)();
  const onStopMigration = (0, _react.useCallback)(() => {
    stopMigration(migrationStats.id);
  }, [migrationStats.id, stopMigration]);
  const finishedCount = migrationStats.rules.completed + migrationStats.rules.failed;
  const progressValue = finishedCount / migrationStats.rules.total * 100;
  const preparing = migrationStats.rules.pending === migrationStats.rules.total;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "migrationProgressPanel",
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_migration_panel_title.MigrationPanelTitle, {
    migrationStats: migrationStats
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18n.RULE_MIGRATION_PROGRESS_DESCRIPTION(migrationStats.rules.total))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "stop",
    isLoading: isStopping,
    onClick: onStopMigration,
    "data-test-subj": "stopMigrationButton"
  }, isStopping ? i18n.RULE_MIGRATION_STOPPING_TRANSLATION_BUTTON : i18n.RULE_MIGRATION_STOP_TRANSLATION_BUTTON))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: _aiAssistantIcon.AssistantIcon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    subdued: true,
    "data-test-subj": "ruleMigrationDescription"
  }, preparing ? i18n.RULE_MIGRATION_PREPARING : i18n.RULE_MIGRATION_TRANSLATING)), !isStopping && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "ruleMigrationSpinner"
  }))), !preparing && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: progressValue,
    valueText: `${Math.floor(progressValue)}%`,
    max: 100,
    color: (0, _eui.tint)(euiTheme.colors.success, 0.25),
    "data-test-subj": "ruleMigrationProgressBar"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_read_more.RuleMigrationsReadMore, null)));
});
MigrationProgressPanel.displayName = 'MigrationProgressPanel';