"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationPanelTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var _use_is_open_state = require("../../../../common/hooks/use_is_open_state");
var _panel_text = require("../../../../common/components/panel_text");
var _use_update_migration = require("../../logic/use_update_migration");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_delete_migration = require("../../logic/use_delete_migration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MigrationPanelTitle = exports.MigrationPanelTitle = /*#__PURE__*/_react.default.memo(({
  migrationStats
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [name, setName] = (0, _react.useState)(migrationStats.name);
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const {
    isOpen: isPopoverOpen,
    close: closePopover,
    toggle: togglePopover
  } = (0, _use_is_open_state.useIsOpenState)(false);
  const {
    isOpen: isDeleteModalOpen,
    open: openDeleteModal,
    close: closeDeleteModal
  } = (0, _use_is_open_state.useIsOpenState)(false);
  const onRenameError = (0, _react.useCallback)(() => {
    setName(migrationStats.name); // revert to original name on error. Error toast will be shown by the useUpdateMigration hook
  }, [migrationStats.name]);
  const {
    mutate: deleteMigration,
    isLoading: isDeletingMigration
  } = (0, _use_delete_migration.useDeleteMigration)(migrationStats.id);
  const {
    mutate: updateMigration,
    isLoading: isUpdatingMigrationName
  } = (0, _use_update_migration.useUpdateMigration)(migrationStats.id, {
    onError: onRenameError
  });
  const cancelEdit = (0, _react.useCallback)(() => {
    setIsEditing(false);
  }, []);
  const saveName = (0, _react.useCallback)(value => {
    setName(value);
    updateMigration({
      name: value
    });
    setIsEditing(false);
  }, [updateMigration]);
  const confirmDeleteMigration = (0, _react.useCallback)(() => {
    deleteMigration();
    closeDeleteModal();
  }, [deleteMigration, closeDeleteModal]);
  const isDeletable = (0, _react.useMemo)(() => migrationStats.status !== _constants.SiemMigrationTaskStatus.RUNNING, [migrationStats.status]);
  const showRename = (0, _react.useCallback)(() => {
    closePopover();
    setIsEditing(true);
  }, [closePopover]);
  const showDelete = (0, _react.useCallback)(() => {
    closePopover();
    openDeleteModal();
  }, [closePopover, openDeleteModal]);
  const stopPropagation = (0, _react.useCallback)(e => {
    e.stopPropagation(); // prevent click events from bubbling up and toggle the collapsible panel
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, isEditing ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    onClick: stopPropagation
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditText, {
    defaultValue: name,
    size: "s",
    inputAriaLabel: "Migration name",
    onCancel: cancelEdit,
    onSave: saveName,
    startWithEditOpen: true
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    semiBold: true,
    "data-test-subj": "migrationPanelTitleName"
  }, /*#__PURE__*/_react.default.createElement("p", null, name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    onClick: stopPropagation
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesVertical",
      onClick: togglePopover,
      "aria-label": i18n.OPEN_MIGRATION_OPTIONS_BUTTON,
      "data-test-subj": "openMigrationOptionsButton",
      isLoading: isUpdatingMigrationName || isDeletingMigration
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "pencil",
    onClick: showRename,
    "data-test-subj": "renameMigrationItem"
  }, i18n.RENAME_MIGRATION_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "trash",
    onClick: showDelete,
    disabled: !isDeletable,
    css: {
      color: isDeletable ? euiTheme.colors.danger : undefined
    },
    "data-test-subj": "deleteMigrationItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isDeletable ? undefined : i18n.NOT_DELETABLE_MIGRATION_TEXT
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.DELETE_BUTTON_TEXT))))), isDeleteModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18n.DELETE_MIGRATION_TITLE,
    onCancel: closeDeleteModal,
    onConfirm: confirmDeleteMigration,
    confirmButtonText: i18n.DELETE_MIGRATION_TEXT,
    cancelButtonText: i18n.CANCEL_DELETE_MIGRATION_TEXT,
    buttonColor: "danger",
    isLoading: isDeletingMigration
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DELETE_MIGRATION_DESCRIPTION)))));
});
MigrationPanelTitle.displayName = 'MigrationPanelTitle';