"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = exports.SiemMigrationsRoutes = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _pages = require("./rules/pages");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SiemMigrationsRoutes = () => {
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_security_route_page_wrapper.SecurityRoutePageWrapper, {
    pageName: _constants.SecurityPageName.siemMigrationsRules
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.SIEM_MIGRATIONS_RULES_PATH}/:migrationId?`,
    component: _pages.MigrationRulesPage
  }))));
};
exports.SiemMigrationsRoutes = SiemMigrationsRoutes;
const routes = exports.routes = [{
  path: _constants.SIEM_MIGRATIONS_RULES_PATH,
  component: SiemMigrationsRoutes
}];