"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateOrReplace = useNavigateOrReplace;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useNavigateOrReplace(to, /** Additional onClick callback */
additionalOnClick) {
  const history = (0, _reactRouterDom.useHistory)();
  const onClick = (0, _react.useCallback)(event => {
    try {
      if (additionalOnClick) {
        additionalOnClick(event);
      }
    } catch (error) {
      event.preventDefault();
      throw error;
    }
    if (event.defaultPrevented) {
      return;
    }
    if (event.button !== 0) {
      return;
    }
    if (event.currentTarget instanceof HTMLAnchorElement && event.currentTarget.target !== '' && event.currentTarget.target !== '_self') {
      return;
    }
    if (event.metaKey || event.altKey || event.ctrlKey || event.shiftKey) {
      return;
    }
    event.preventDefault();
    history.push(to);
  }, [history, additionalOnClick, to]);
  return {
    href: history.createHref(to),
    onClick
  };
}