"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLinkProps = useLinkProps;
var _reactRedux = require("react-redux");
var _use_navigate_or_replace = require("./use_navigate_or_replace");
var selectors = _interopRequireWildcard(require("../store/selectors"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get an `onClick` function and an `href` string. Use these as props for `<a />` elements.
 * `onClick` will use navigate to the `panelViewAndParameters` using `history.push`.
 * the `href` points to `panelViewAndParameters`.
 * Existing `search` parameters are maintained.
 */
function useLinkProps(id, panelViewAndParameters) {
  const search = (0, _reactRedux.useSelector)(state => selectors.relativeHref(state.analyzer[id])(panelViewAndParameters));
  return (0, _use_navigate_or_replace.useNavigateOrReplace)({
    search
  });
}