"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectedNode = exports.relativeHref = exports.panelViewAndParameters = exports.ariaActiveDescendant = void 0;
var _rison = require("@kbn/rison");
var _reselect = require("reselect");
var _panel_view_and_parameters = require("../panel_view_and_parameters");
var _parameter_name = require("../parameter_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * id of the "current" tree node (fake-focused)
 */
const ariaActiveDescendant = exports.ariaActiveDescendant = (0, _reselect.createSelector)(uiState => uiState,
// eslint-disable-next-line @typescript-eslint/no-shadow
({
  ariaActiveDescendant
}) => {
  return ariaActiveDescendant;
});

/**
 * id of the currently "selected" tree node
 */
const selectedNode = exports.selectedNode = (0, _reselect.createSelector)(uiState => uiState,
// eslint-disable-next-line @typescript-eslint/no-shadow
({
  selectedNode
}) => {
  return selectedNode;
});

/**
 * Which view should show in the panel, as well as what parameters should be used.
 * Calculated using the query string
 */
const panelViewAndParameters = exports.panelViewAndParameters = (0, _reselect.createSelector)(state => state.locationSearch, state => state.resolverComponentInstanceID, (locationSearch, resolverComponentInstanceID) => {
  return (0, _panel_view_and_parameters.panelViewAndParameters)({
    locationSearch,
    resolverComponentInstanceID
  });
});

/**
 * Return a relative href (which includes just the 'search' part) that contains an encoded version of `params `.
 * All other values in the 'search' will be kept.
 * Use this to get an `href` for an anchor tag.
 */
const relativeHref = exports.relativeHref = (0, _reselect.createSelector)(state => state.locationSearch, state => state.resolverComponentInstanceID, (locationSearch, resolverComponentInstanceID) => {
  return params => {
    /**
     * This is only possible before the first `'appReceivedNewExternalProperties'` action is fired.
     */
    if (locationSearch === undefined || resolverComponentInstanceID === undefined) {
      return undefined;
    }
    const urlSearchParams = new URLSearchParams(locationSearch);
    const value = (0, _rison.encode)(params);
    urlSearchParams.set((0, _parameter_name.parameterName)(resolverComponentInstanceID), value);
    return `?${urlSearchParams.toString()}`;
  };
});