"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.expectVectorsToBeClose = expectVectorsToBeClose;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Used to assert that two Vector2s are close to each other (accounting for round-off errors.)
 */
function expectVectorsToBeClose(first, second) {
  expect(first[0]).toBeCloseTo(second[0]);
  expect(first[1]).toBeCloseTo(second[1]);
}