"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCtiDashboardLinks = void 0;
var _react = require("react");
var _kibana = require("../../../common/lib/kibana");
var _api = require("../../../common/containers/dashboards/api");
var _api2 = require("../../../common/containers/tags/api");
var _use_fetch = require("../../../common/hooks/use_fetch");
var _constants = require("../../../../common/constants");
var _link_to = require("../../../common/components/link_to");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CTI_TAG_NAME = 'threat intel';
const useCtiInstalledDashboards = () => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    data: ctiTags,
    isLoading: isLoadingTags,
    error: errorTags
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.CTI_TAGS, _api2.getTagsByName, {
    initialParameters: {
      http,
      tagName: CTI_TAG_NAME
    }
  });
  const {
    fetch: fetchDashboards,
    data: dashboards,
    isLoading: isLoadingDashboards
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.CTI_TAGS, _api.getDashboardsByTagIds);
  (0, _react.useEffect)(() => {
    if (!isLoadingTags && !errorTags && ctiTags !== null && ctiTags !== void 0 && ctiTags.length) {
      fetchDashboards({
        http,
        tagIds: ctiTags.map(tag => tag.id)
      });
    }
  }, [errorTags, fetchDashboards, http, isLoadingTags, ctiTags]);
  return {
    dashboards,
    isLoading: isLoadingDashboards || isLoadingTags
  };
};
const useCtiDashboardLinks = ({
  tiDataSources = []
}) => {
  const {
    dashboards
  } = useCtiInstalledDashboards();
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const listItems = (0, _react.useMemo)(() => {
    var _dashboards$map;
    const installedDashboardIds = (_dashboards$map = dashboards === null || dashboards === void 0 ? void 0 : dashboards.map(({
      id
    }) => id)) !== null && _dashboards$map !== void 0 ? _dashboards$map : [];
    return tiDataSources.map(tiDataSource => {
      let path = '';
      if (tiDataSource.dashboardId && installedDashboardIds.includes(tiDataSource.dashboardId)) {
        path = `${getSecuritySolutionUrl({
          deepLinkId: _constants.SecurityPageName.dashboards,
          path: tiDataSource.dashboardId
        })}`;
      }
      return {
        title: tiDataSource.name,
        count: tiDataSource.count,
        path
      };
    });
  }, [dashboards, tiDataSources, getSecuritySolutionUrl]);
  return {
    listItems
  };
};
exports.useCtiDashboardLinks = useCtiDashboardLinks;