"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFiltersForSignalsByCategory = void 0;
var _react = require("react");
var _default_config = require("../../../detections/components/alerts_table/default_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// On the Overview page, in the Detection Alert Trend, we never show
// "building block" alerts to remove noise from the Overview UI.
// https://www.elastic.co/guide/en/security/current/building-block-rule.html
const SHOW_BUILDING_BLOCK_ALERTS = false;
const useFiltersForSignalsByCategory = baseFilters => {
  const resultingFilters = (0, _react.useMemo)(() => [...baseFilters, ...(0, _default_config.buildShowBuildingBlockFilter)(SHOW_BUILDING_BLOCK_ALERTS)], [baseFilters]);
  return resultingFilters;
};
exports.useFiltersForSignalsByCategory = useFiltersForSignalsByCategory;