"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsByStatusVisualizationData = exports.openAlertsVisualizationId = exports.closedAlertsVisualizationId = exports.acknowledgedAlertsVisualizationId = void 0;
var _use_visualization_response = require("../../../../common/components/visualization_actions/use_visualization_response");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openAlertsVisualizationId = exports.openAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-open`;
const acknowledgedAlertsVisualizationId = exports.acknowledgedAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}- acknowledged`;
const closedAlertsVisualizationId = exports.closedAlertsVisualizationId = `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-closed`;
const useAlertsByStatusVisualizationData = () => {
  var _ref, _ref2, _ref3;
  const {
    tables: openAlertsTables
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: openAlertsVisualizationId
  });
  const {
    tables: acknowledgedAlertsTables
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: acknowledgedAlertsVisualizationId
  });
  const {
    tables: closedAlertsTables
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: closedAlertsVisualizationId
  });
  const visualizationOpenAlertsData = (_ref = openAlertsTables && openAlertsTables.meta.statistics.totalCount) !== null && _ref !== void 0 ? _ref : 0;
  const visualizationAcknowledgedAlertsData = (_ref2 = acknowledgedAlertsTables && acknowledgedAlertsTables.meta.statistics.totalCount) !== null && _ref2 !== void 0 ? _ref2 : 0;
  const visualizationClosedAlertsData = (_ref3 = closedAlertsTables && closedAlertsTables.meta.statistics.totalCount) !== null && _ref3 !== void 0 ? _ref3 : 0;
  const visualizationTotalAlertsData = visualizationOpenAlertsData + visualizationAcknowledgedAlertsData + visualizationClosedAlertsData;
  return {
    open: visualizationOpenAlertsData,
    acknowledged: visualizationAcknowledgedAlertsData,
    closed: visualizationClosedAlertsData,
    total: visualizationTotalAlertsData
  };
};
exports.useAlertsByStatusVisualizationData = useAlertsByStatusVisualizationData;