"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartLabel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _formatted_number = require("../../../../common/components/formatted_number");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PlaceHolder = _styled.default.div`
  padding: ${props => props.theme.euiTheme.size.s};
`;
const ChartLabelComponent = ({
  count,
  onClick
}) => {
  const onLabelClick = (0, _react.useCallback)(() => onClick && onClick(), [onClick]);
  if (count) {
    return onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onLabelClick
    }, /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count
    }))) : /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count
    }));
  }
  return /*#__PURE__*/_react.default.createElement(PlaceHolder, null);
};
ChartLabelComponent.displayName = 'ChartLabelComponent';
const ChartLabel = exports.ChartLabel = /*#__PURE__*/_react.default.memo(ChartLabelComponent);