"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
var _constants2 = require("../constants");
var _use_url_detail = require("./hooks/use_url_detail");
var _onboarding_context = require("./onboarding_context");
var _onboarding_header = require("./onboarding_header");
var _onboarding_body = require("./onboarding_body");
var _centered_loading_spinner = require("../../common/components/centered_loading_spinner");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingRouter = exports.OnboardingRouter = /*#__PURE__*/_react.default.memo(() => {
  const {
    config
  } = (0, _onboarding_context.useOnboardingContext)();
  const topicPathParam = (0, _react.useMemo)(() => {
    const availableTopics = [...config.values()].map(({
      id
    }) => id) // available topic ids
    .filter(id => id !== _constants2.OnboardingTopicId.default) // except "default"
    .join('|');
    if (availableTopics) {
      return `/:topicId(${availableTopics})?`; // optional parameter}
    }
    return ''; // only default topic available, no need for topic path parameter
  }, [config]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.ONBOARDING_PATH}${topicPathParam}`,
    exact: true,
    component: OnboardingRoute
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.ONBOARDING_PATH}/*`,
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.ONBOARDING_PATH
    })
  }));
});
OnboardingRouter.displayName = 'OnboardingRouter';
const OnboardingRoute = /*#__PURE__*/_react.default.memo(({
  match: {
    params
  },
  location
}) => {
  const {
    isLoading
  } = (0, _use_url_detail.useSyncUrlDetails)({
    pathTopicId: params.topicId || null,
    hashCardId: (0, _use_url_detail.getCardIdFromHash)(location.hash)
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_onboarding_header.OnboardingHeader, null), /*#__PURE__*/_react.default.createElement(_onboarding_body.OnboardingBody, null));
});
OnboardingRoute.displayName = 'OnboardingContent';