"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_load_action_types = require("@kbn/elastic-assistant/impl/connectorland/use_load_action_types");
var _kibana_react = require("../../../../../../common/lib/kibana/kibana_react");
var _missing_privileges = require("./missing_privileges");
var _connector_setup = require("./connector_setup");
var _connector_selector_panel = require("./connector_selector_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorCards = exports.ConnectorCards = /*#__PURE__*/_react.default.memo(({
  connectors,
  onNewConnectorSaved,
  canCreateConnectors,
  selectedConnectorId,
  onConnectorSelected
}) => {
  const {
    http,
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const {
    data: actionTypes
  } = (0, _use_load_action_types.useLoadActionTypes)({
    http,
    toasts: notifications.toasts
  });
  const onNewConnectorStoredSave = (0, _react.useCallback)(newConnector => {
    onNewConnectorSaved(newConnector.id);
    // default select the new connector created
    onConnectorSelected(newConnector);
  }, [onConnectorSelected, onNewConnectorSaved]);
  if (!connectors || !actionTypes) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const hasConnectors = connectors.length > 0;

  // show callout when user is missing actions.save privilege
  if (!hasConnectors && !canCreateConnectors) {
    return /*#__PURE__*/_react.default.createElement(_missing_privileges.ConnectorsMissingPrivilegesCallOut, {
      level: "all"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
            height: 160px;
          `
  }, hasConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_connector_selector_panel.ConnectorSelectorPanel, {
    selectedConnectorId: selectedConnectorId,
    connectors: connectors,
    onConnectorSelected: onConnectorSelected
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_connector_setup.ConnectorSetup, {
    actionTypes: actionTypes,
    onConnectorSaved: onNewConnectorStoredSave
  }))));
});
ConnectorCards.displayName = 'ConnectorCards';