"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _plugin_template_wrapper = require("../../common/components/plugin_template_wrapper");
var _centered_loading_spinner = require("../../common/components/centered_loading_spinner");
var _use_space_id = require("../../common/hooks/use_space_id");
var _constants = require("../constants");
var _onboarding_context = require("./onboarding_context");
var _onboarding_banner = require("./onboarding_banner");
var _onboarding_router = require("./onboarding_router");
var _onboarding_footer = require("./onboarding_footer");
var _onboarding = require("./onboarding.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingPage = exports.OnboardingPage = /*#__PURE__*/_react.default.memo(() => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const styles = (0, _onboarding.useOnboardingStyles)();
  if (!spaceId) {
    return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
      size: "l",
      topOffset: "10em"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_onboarding_context.OnboardingContextProvider, {
    spaceId: spaceId
  }, /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    paddingSize: "none",
    "data-test-subj": "onboarding-hub-page",
    className: styles
  }, /*#__PURE__*/_react.default.createElement(_onboarding_banner.OnboardingAVCBanner, null), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    restrictWidth: _constants.PAGE_CONTENT_WIDTH,
    paddingSize: "xl",
    className: "onboardingSection"
  }, /*#__PURE__*/_react.default.createElement(_onboarding_router.OnboardingRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    restrictWidth: _constants.PAGE_CONTENT_WIDTH,
    paddingSize: "xl",
    className: "onboardingSection"
  }, /*#__PURE__*/_react.default.createElement(_onboarding_footer.OnboardingFooter, null))));
});
OnboardingPage.displayName = 'OnboardingPage';