"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeEntity = exports.normalizeEntities = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Interface to represent a normalized entity
 */

/**
 * Interface to represent normalized entities
 */

/**
 * Normalizes a single note
 */
const normalizeEntity = res => ({
  entities: {
    notes: {
      [res.noteId]: res
    }
  },
  result: res.noteId
});

/**
 * Normalizes an array of notes
 */
exports.normalizeEntity = normalizeEntity;
const normalizeEntities = res => ({
  entities: {
    notes: res.reduce((obj, item) => Object.assign(obj, {
      [item.noteId]: item
    }), {})
  },
  result: res.map(note => note.noteId)
});
exports.normalizeEntities = normalizeEntities;